% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.nca.R
\name{est.nca}
\alias{est.nca}
\title{Estimate individual NCA metrics.}
\usage{
est.nca(time, conc, backExtrp = FALSE, negConcExcl = FALSE,
  doseType = "ns", adminType = "extravascular", doseAmt = NULL,
  method = "linearup-logdown", AUCTimeRange = NULL,
  LambdaTimeRange = NULL, LambdaExclude = NULL, doseTime = doseTime,
  Tau = NULL, TI = NULL, simFile = NULL, dset = "obs",
  onlyNCA = FALSE, extrapolate = FALSE, sparse_compute = FALSE,
  force_extrapolate = FALSE, ...)
}
\arguments{
\item{time}{Numeric array for time}

\item{conc}{Numeric array for concentration}

\item{backExtrp}{If back-extrapolation is needed for AUC (TRUE or FALSE) 
(\strong{FALSE})}

\item{negConcExcl}{Exclude -ve conc (\strong{FALSE})}

\item{doseType}{Steady-state (ss) or non-steady-state (ns) dose
(\strong{"ns"})}

\item{adminType}{Route of administration
(iv-bolus,iv-infusion,extravascular) (\strong{"extravascular"})}

\item{doseAmt}{Dose amounts (\strong{"NULL"})}

\item{method}{Method to estimate AUC. The \code{"linear"} method applies the linear
trapezoidal rule to estimate the area under the curve. The \code{"log"} method
applies the logarithmic trapezoidal rule to estimate the area under the
curve. The \code{"linearup-logdown"} method applies the linear trapezoidal rule to
estimate the area under the curve for the ascending part of the curve and
the logarithmic trapezoidal rule to estimate the area under the curve for
the descending part of the curve.}

\item{AUCTimeRange}{User-defined window of time used to estimate AUC 
(\strong{"NULL"})}

\item{LambdaTimeRange}{User-defined window of time to estimate elimination 
rate-constant (\strong{"NULL"})}

\item{LambdaExclude}{User-defined excluded observation time points for
estimation of elimination rate-constant (\strong{"NULL"})}

\item{doseTime}{Dose time prior to the first observation for steady-state
data (\strong{\code{NULL}})}

\item{Tau}{Dosing interval for steady-state data (\strong{"NULL"})}

\item{TI}{Infusion duration (\strong{"NULL"})}

\item{simFile}{Name of the simulated concentration-time data if present
(\strong{"NULL"})}

\item{dset}{Type, i.e., observed or simulated concentration-time data set
("obs" or "sim") (\strong{"obs"})}

\item{onlyNCA}{If \code{TRUE} only NCA is performed and ppc part is ignored
although simFile is not \code{NULL}. Default is \strong{\code{FALSE}}}

\item{extrapolate}{Should the function extrapolate from the last observation to infinity?}

\item{sparse_compute}{Should NCA metrics be computed even with only one sample?}

\item{force_extrapolate}{Extrapolate AUC_inf with sparse data.  Sparse data is defined as 
fewer than 3 points after Cmax for non-bolus input.  In that case, Cmax is included in the extrapolation 
and only one extra point in required for extrapolation.}

\item{...}{Arguments passed from other functions.  Not used.}
}
\value{
An array of estimated NCA metrics
}
\description{
Estimates a comprehensive set of NCA metrics
for a given individual using concentration vs. time data.
}
\details{
\pkg{est.nca} estimates a comprehensive set of NCA metrics using the
concentration-time profile of an individual. NCA metrics are estimated
according to traditional PK calculations. The names of the various NCA
metrics estimated in this package are assigned mainly following the names
used in WinNonlin. This package accepts any of the three different types of
drug administration, (i) iv-bolus, (ii) iv-infusion and (iii) extravascular;
\pkg{ncappc} also can accept both non-steady state and steady-state data. 
The NCA metrics that are estimated and reported by \pkg{ncappc} are listed 
below.
\itemize{
 \item \strong{C0} is the initial concentration at the dosing time. It is 
 the observed concentration at the dosing time, if available. Otherwise 
 it is approximated using the following rules.
 \item \strong{Cmax, Tmax and Cmax_D} are the value and the time of maximum
 observed concentration, respectively. If the maximum concentration is not
 unique, the first maximum is used. For steady state data, The maximum value
 between the dosing intervals is considered. Cmax_D is the dose normalized
 maximum observed concentration.
 \item \strong{Clast and Tlast} are the last measurable positive
 concentration and the corresponding time, respectively. 
 \item \strong{AUClast} is the area under the concentration vs. time curve
 from the first observed to last measurable concentration.
 \item \strong{AUMClast} is the first moment of the concentration vs. time
 curve from the first observed to last measurable concentration.
 \item \strong{MRTlast} is the mean residence time from the first observed 
 to last measurable concentration.
 \item \strong{No_points_Lambda_z} is the number of observed data points 
 used to determine the best fitting regression line in the elimination 
 phase.
 \item \strong{AUC_pBack_Ext_obs} is the percentage of AUCINF_obs that is 
 contributed by the back extrapolation to estimate C0.
 \item \strong{AUC_pBack_Ext_pred} is the percentage of AUCINF_pred that is 
 contributed by the back extrapolation to estimate C0.
 \item \strong{AUClower_upper} is the AUC under the concentration-time 
 profile within the user-specified window of time provided as the 
 "AUCTimeRange" argument. In case of empty "AUCTimeRange" argument, 
 AUClower_upper is the same as AUClast.
 \item \strong{Rsq, Rsq_adjusted and Corr_XY} are regression coefficient 
 of the regression line used to estimate the elimination rate constant, the 
 adjusted value of Rsq and the square root of Rsq, respectively.
 \item \strong{Lambda_z} is the elimination rate constant estimated from the 
 regression line representing the terminal phase of the concentration-time 
 data.
 \item \strong{Lambda_lower and Lambda_upper} are the lower and upper limit 
 of the time values from the concentration-time profile used to estimate 
 Lambda_z, respectively, in case the "LambdaTimeRange" is used to specify 
 the time range.
 \item \strong{HL_Lambda_z} is terminal half-life of the drug.
 \item \strong{AUCINF_obs and AUCINF_obs_D} are AUC estimated from the first 
 sampled data extrapolated to infinity and its dose normalized version, 
 respectively. The extrapolation in the terminal phase is based on the last 
 observed concentration Clast_obs.
 \item \strong{AUC_pExtrap_obs} is the percentage of the AUCINF_obs that is 
 contributed by the extrapolation from the last sampling time to infinity.
 \item \strong{AUMCINF_obs} is AUMC estimated from the first sampled data 
 extrapolated to infinity. The extrapolation in the terminal phase is based 
 on the last observed concentration.
 \item \strong{AUMC_pExtrap_obs} is the percentage of the AUMCINF_obs that 
 is contributed by the extrapolation from the last sampling time to infinity.
 \item \strong{Vz_obs} is the volume of distribution estimated based on 
 total AUC
 \item \strong{Cl_obs} is total body clearance.
 \item \strong{AUCINF_pred and AUCINF_pred_D} are AUC from the first sampled 
 data extrapolated to infinity and its dose normalized version, respectively.
 The extrapolation in the terminal phase is based on the last predicted 
 concentration obtained from the regression line used to estimate Lambda_z 
 (Clast_pred).
 \item \strong{AUC_pExtrap_pred} is the percentage of the AUCINF_pred that 
 is contributed by the extrapolation from the last sampling time to infinity.
 \item \strong{AUMCINF_pred} is AUMC estimated from the first sampled data 
 extrapolated to infinity. The extrapolation in the terminal phase is based 
 on the last predicted concentration obtained from the regression line used 
 to estimate Lambda_z (Clast_pred).
 \item \strong{AUMC_pExtrap_pred} is the percentage of the AUMCINF_pred that 
 is contributed by the extrapolation from the last sampling time to infinity.
 \item \strong{Vz_pred} is the volume of distribution estimated based on 
 AUCINF_pred.
 \item \strong{Cl_pred} is the total body clearance estimated based on 
 AUCINF_pred.
 \item \strong{MRTINF_obs} is the mean residence time from the first 
 sampled time extrapolated to infinity based on the last observed 
 concentration (Clast_obs).
 \item \strong{MRTINF_pred} is the mean residence time from the first 
 sampled time extrapolated to infinity based on the last predicted 
 concentration obtained from the regression line used to estimate Lambda_z 
 (Clast_pred).
 \item \strong{Tau} is the dosing interval for steady-state data. 
 \item \strong{Cmin and Tmin} are the minimum concentration between 0 and 
 Tau and the corresponding time, respectively.
 \item \strong{Cavg} is the average concentration between 0 and Tau for 
 steady-state data.
 \item \strong{AUCtau and AUMCtau} are AUC and AUMC between 0 and Tau for 
 steady-state data.
 \item \strong{Clss} is an estimate of the total body clearance for
 steady-state data.
 \item \strong{Vss_obs and Vss_pred} are estimated volume of distribution at 
 steady-state based on Clast_obs and Clast_pred, respectively.
 \item \strong{p_Fluctuation} is the percentage of the fluctuation of the 
 concentration between 0 and Tau for steady-state data.
 \item \strong{Accumulation_Index} is \eqn{1/(1-e^(-\lambda_z*\tau))}
}
}
