% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.r
\name{nc.get.coordinate.axes}
\alias{nc.get.coordinate.axes}
\title{Get a list of dimension variables and axes for a variable's coordinate variable}
\usage{
nc.get.coordinate.axes(f, v)
}
\arguments{
\item{f}{The file (an object of class \code{ncdf4})}

\item{v}{The name of a variable}
}
\value{
A named character vector containing axes, the names of which are the corresponding dimension variables.
}
\description{
Get a list of dimension variables and axes for a variable's coordinate variable.
}
\details{
The CF metadata standard defines a convention for definining 2-dimensional variables to accompany pairs of dimension variables. Usually these are latitude and longitude variables, and accompany projected grids. This function returns a named list of axes, the names of which are the associated dimension variables.
}
\examples{
## Get coordinate axes from file.
\dontrun{
f <- nc_open("pr.nc")
coord.axes <- nc.get.coordinate.axes(f, "pr")
nc_close(f)
}

}
\references{
\url{http://cfconventions.org/Data/cf-conventions/cf-conventions-1.8/cf-conventions.html#_two_dimensional_latitude_longitude_coordinate_variables}
}
