% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCUDT.R
\docType{class}
\name{NCUDT}
\alias{NCUDT}
\title{NetCDF user-defined type}
\description{
This class represents user-defined types in a netCDF file.
Interpretation of the UDT typically requires knowledge of the data set or
application.
}
\section{Super class}{
\code{\link[ncdfCF:NCObject]{ncdfCF::NCObject}} -> \code{NCUDT}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{clss}}{The class of the UDT, one of "builtin", "compound", "enum",
"opaque", or "vlen".}

\item{\code{size}}{Size in bytes of a single item of the type (or a single
element of a "vlen").}

\item{\code{basetype}}{Name of the netCDF base type of each element ("enum" and
"vlen" only).}

\item{\code{value}}{Named vector with numeric values of all members ("enum"
only).}

\item{\code{offset}}{Named vector with the offset of each field in bytes from
the beginning of the "compound" type.}

\item{\code{subtype}}{Named vector with the netCDF base type name of each field
of a "compound" type.}

\item{\code{dimsizes}}{Named list with array dimensions of each field of a
"compound" type. A \code{NULL} length indicates a scalar.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NCUDT-new}{\code{NCUDT$new()}}
\item \href{#method-NCUDT-clone}{\code{NCUDT$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCObject" data-id="attribute"><a href='../../ncdfCF/html/NCObject.html#method-NCObject-attribute'><code>ncdfCF::NCObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCObject" data-id="print_attributes"><a href='../../ncdfCF/html/NCObject.html#method-NCObject-print_attributes'><code>ncdfCF::NCObject$print_attributes()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCUDT-new"></a>}}
\if{latex}{\out{\hypertarget{method-NCUDT-new}{}}}
\subsection{Method \code{new()}}{
Create a new netCDF user-defined type. This class represents
a user-defined type. It is instantiated when opening a netCDF resource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCUDT$new(id, name, clss, size, basetype, value, offset, subtype, dimsizes)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Numeric identifier of the user-defined type.}

\item{\code{name}}{Character string with the name of the user-defined type.}

\item{\code{clss}}{The class of the UDT, one of "builtin", "compound", "enum",
"opaque", or "vlen".}

\item{\code{size}}{Size in bytes of a single item of the type (or a single
element of a "vlen").}

\item{\code{basetype}}{Name of the netCDF base type of each element ("enum" and
"vlen" only).}

\item{\code{value}}{Named vector with numeric values of all members ("enum"
only).}

\item{\code{offset}}{Named vector with the offset of each field in bytes from
the beginning of the "compound" type.}

\item{\code{subtype}}{Named vector with the netCDF base type name of each field
of a "compound" type.}

\item{\code{dimsizes}}{Named list with array dimensions of each field of a
"compound" type. A \code{NULL} length indicates a scalar.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCUDT-clone"></a>}}
\if{latex}{\out{\hypertarget{method-NCUDT-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCUDT$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
