% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFVariableBase.R
\docType{class}
\name{CFVariableBase}
\alias{CFVariableBase}
\title{Base ancestor of CFVariable and CFArray}
\description{
This class is a basic ancestor to \link{CFVariable} and \link{CFArray}. It
should not be instantiated directly, use the descendant classes instead.

This class provides access to common properties of data variables and the
data they contain.
}
\section{Super class}{
\code{\link[ncdfCF:CFObject]{ncdfCF::CFObject}} -> \code{CFVariableBase}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{axes}}{List of instances of classes descending from \link{CFAxis} that
are the axes of the data object. If there are any scalar axes, they are
listed after the axes that associate with the dimensions of the data.
(In other words, axes \verb{1..n} describe the \verb{1..n} data dimensions, while
any axes \verb{n+1..m} are scalar axes.)}

\item{\code{crs}}{The coordinate reference system of this variable, as an
instance of \link{CFGridMapping}. If this field is \code{NULL}, the horizontal
component of the axes are in decimal degrees of longitude and latitude.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFVariableBase-new}{\code{CFVariableBase$new()}}
\item \href{#method-CFVariableBase-time}{\code{CFVariableBase$time()}}
\item \href{#method-CFVariableBase-summarise}{\code{CFVariableBase$summarise()}}
\item \href{#method-CFVariableBase-clone}{\code{CFVariableBase$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="append_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-append_attribute'><code>ncdfCF::CFObject$append_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-attribute'><code>ncdfCF::CFObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="delete_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-delete_attribute'><code>ncdfCF::CFObject$delete_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="print_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-print_attributes'><code>ncdfCF::CFObject$print_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="set_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-set_attribute'><code>ncdfCF::CFObject$set_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="write_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-write_attributes'><code>ncdfCF::CFObject$write_attributes()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFVariableBase-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFVariableBase-new}{}}}
\subsection{Method \code{new()}}{
Create an instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFVariableBase$new(var, group, axes, crs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{var}}{The NC variable that describes this data object.}

\item{\code{group}}{The group that this data object should live in.}

\item{\code{axes}}{A \code{list} of \link{CFAxis} descendant instances that describe the
axes of the data object.}

\item{\code{crs}}{The \link{CFGridMapping} instance of this data object, or \code{NULL}
when no grid mapping is available.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFVariableBase-time"></a>}}
\if{latex}{\out{\hypertarget{method-CFVariableBase-time}{}}}
\subsection{Method \code{time()}}{
Return the time object from the axis representing time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFVariableBase$time(want = "time")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{want}}{Character string with value "axis" or "time", indicating
what is to be returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{want = "axis"} the \link{CFAxisTime} axis; if \code{want = "time"} the
\code{CFTime} instance of the axis, or \code{NULL} if the variable does not have a
"time" dimension.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFVariableBase-summarise"></a>}}
\if{latex}{\out{\hypertarget{method-CFVariableBase-summarise}{}}}
\subsection{Method \code{summarise()}}{
Summarise the temporal dimension of the data, if present, to
a lower resolution, using a user-supplied aggregation function.

Attributes are copied from the input data variable or data array. Note
that after a summarisation the attributes may no longer be accurate.
This method tries to sanitise attributes (such as removing
\code{scale_factor} and \code{add_offset}, when present, as these will no longer
be appropriate in most cases) but the onus is on the calling code (or
yourself as interactive coder). Attributes like \code{standard_name} and
\code{cell_methods} likely require an update in the output of this method,
but the appropriate new values are not known to this method. Use
\code{CFArray$set_attribute()} on the result of this method to set or update
attributes as appropriate.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFVariableBase$summarise(name, period, fun)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Character vector with a name for each of the results that
\code{fun} returns. So if \code{fun} has 2 return values, this should be a vector
of length 2. Any missing values are assigned a default name of
"result_#" (with '#' being replaced with an ordinal number).}

\item{\code{period}}{The period to summarise to. Must be one of either "day",
"dekad", "month", "quarter", "season", "year". A "quarter" is the
standard calendar quarter such as January-March, April-June, etc. A
"season" is a meteorological season, such as December-February,
March-May, etc. (any December data is from the year preceding the
January data). The period must be of lower resolution than the
resolution of the time dimension.}

\item{\code{fun}}{A function or a symbol or character string naming a function
that will be applied to each grouping of data. The function must return
an atomic value (such as \code{sum()} or \code{mean()}), or a vector of atomic
values (such as \code{range()}). Lists and other objects are not allowed and
will throw an error that may be cryptic as there is no way that this
method can assert that \code{fun} behaves properly so an error will pop up
somewhere, most probably in unexpected ways. The function may also be
user-defined so you could write a wrapper around a function like \code{lm()}
to return values like the intercept or any coefficients from the object
returned by calling that function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{CFData} object, or a list thereof with as many \code{CFData}
objects as \code{fun} returns values, created in the same group as \code{self}
with the summarised data.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFVariableBase-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFVariableBase-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFVariableBase$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
