% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_geometry.R
\name{read_geometry}
\alias{read_geometry}
\title{Read NetCDF-CF spatial geometries}
\usage{
read_geometry(nc_file)
}
\arguments{
\item{nc_file}{character file path to the nc file to be read.}
}
\value{
sf \code{data.frame} containing spatial geometry of type found in the NetCDF-CF DSG file.
}
\description{
Attempts to convert a NetCDF-CF DSG Simple Geometry file into a sf data.frame.
}
\examples{
huc_eta_nc <- tempfile()
file.copy(system.file('extdata','example_huc_eta.nc', package = 'ncdfgeom'), 
         huc_eta_nc, overwrite = TRUE)
         
vars <- ncmeta::nc_vars(huc_eta_nc)

hucPolygons <- sf::read_sf(system.file('extdata','example_huc_eta.json', package = 'ncdfgeom'))
plot(sf::st_geometry(hucPolygons))
names(hucPolygons)

hucPolygons_nc <- ncdfgeom::write_geometry(nc_file=huc_eta_nc, 
                                          geom_data = hucPolygons, 
                                          instance_dim_name = "station", 
                                          variables = vars$name)
huc_poly <- read_geometry(huc_eta_nc)
plot(sf::st_geometry(huc_poly))
names(huc_poly)

}
\references{
http://cfconventions.org/index.html

\enumerate{
  \item \url{http://cfconventions.org/cf-conventions/cf-conventions.html#_features_and_feature_types}
 }
}
