% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_variants.R
\name{expand_times}
\alias{expand_times}
\title{Expand timestamp ranges.}
\usage{
expand_times(df, start_var, end_var, name = "Expanded",
  fmt = "\%Y-\%m-\%d \%H:\%M:\%OS", vars_to_keep = NULL,
  unit = "hour", tz = "UTC")
}
\arguments{
\item{df}{Data frame (can also be a data.table or a tibble)}

\item{start_var}{Start time column}

\item{end_var}{End time column}

\item{name}{The name of newly created column. Defaults to 'Expanded'}

\item{fmt}{The format of date columns, defaults to Y-M-D H:M:OS}

\item{vars_to_keep}{Which columns you would like to keep}

\item{unit}{By which unit of time you want to expand; the default is day}

\item{tz}{Desired time zone - defaults to UTC}
}
\value{
Returns a full data frame with expanded sequences in a column, e.g. by day or month.
}
\description{
Expand timestamp ranges.
}
\examples{

df <- data.frame(
id = c("1111", "2222", "3333"),
gender = c("M", "F", "F"),
start = c("2018-01-01 15:00:00", "2019-01-01 14:00:00", "2020-01-01 19:00:00"),
end = c("2018-01-01 18:30:00", "2019-01-01 17:30:00", "2020-01-02 02:00:00")
)

expand_times(df, start_var = "start", end_var = "end", 
vars_to_keep = c("id", "gender"), unit = "hour")

}
