% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusMap.R
\name{consensusMap}
\alias{consensusMap}
\title{Create Heatmaps of Consensus Matrices}
\usage{
consensusMap(neatmap_res, link_method = "average")
}
\arguments{
\item{neatmap_res}{Output from the \code{\link{neatmap}} function.}

\item{link_method}{The agglomeration method to be used for hierarchical 
clustering. Defaults to the average linkage method. See other methods in
\code{\link[stats]{hclust}}.}
}
\value{
Returns of a list of heatmaps depicting the consensus matrices of 
each
}
\description{
\code{consensusMap} produces a list of heatmaps from the consensus matrices
produced during the consensus clustering step of the \code{\link{neatmap}}
function.
}
\details{
This function will create a list of heatmaps of the consensus matrices
produced during the consensus clustering step of the \code{\link{neatmap}}
function. The default clustering method used in the heatmaps is hierarchical
clustering using the average linkage method, though other linkage methods
can be used. The consensus cluster matrix is used as a measure of similarity.
The heatmaps are produced using \code{\link[heatmaply]{heatmaply}}.
}
\examples{
# create the data frame using the network, node and edge attributes
df <- netsDataFrame(network_attr_df,
                    node_attr_df,
                    edge_df)

# run the neatmap code on df
neat_res <- neatmap(df, scale_df = "ecdf", max_k = 3, reps = 100, 
                    xlab = "vars", ylab = "nets", xlab_cex = 1, ylab_cex = 1)
                    
# create the list of heatmaps for each iteration
hm_list <- consensusMap(neat_res)
}
\references{
For more information on the consensus matrices, see
\href{https://link.springer.com/article/10.1023\%2FA\%3A1023949509487}{Monti et al.}.
}
\author{
Philippe Boileau, \email{philippe_boileau@berkeley.edu}
}
