% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg.cat.R
\name{neg.cat}
\alias{neg.cat}
\alias{print.neg.cat}
\title{Equivalence Testing for Categorical Variables}
\usage{
neg.cat(
  v1 = NULL,
  v2 = NULL,
  tab = NULL,
  eiU = 0.2,
  data = NULL,
  plot = TRUE,
  save = FALSE,
  nbootpd = 1000,
  alpha = 0.05
)

\method{print}{neg.cat}(x, ...)
}
\arguments{
\item{v1}{first categorical variable}

\item{v2}{second categorical variable}

\item{tab}{contingency table for the two predictor variables}

\item{eiU}{upper limit of equivalence interval}

\item{data}{optional data file containing the categorical variables}

\item{plot}{logical; should a plot be printed out with the effect and the proportional distance}

\item{save}{should the plot be saved to 'jpg' or 'png'}

\item{nbootpd}{number of bootstrap samples for calculating the CI for the proportional distance}

\item{alpha}{nominal acceptable Type I error rate level}

\item{x}{Data frame from neg.cat}

\item{...}{extra arguments}
}
\value{
A \code{list} containing the following:
\itemize{
  \item \code{cramv} Cramer's V statistic
  \item \code{propvar} Proportion of variance explained (V^2)
  \item \code{cil} Lower bound of the confidence interval for Cramer's V
  \item \code{ciu} Upper bound of the confidence interval for Cramer's V
  \item \code{eiU} Upper bound of the negligible effect (equivalence) interval
  \item \code{decis} NHST decision
  \item \code{PD} Proportional distance
  \item \code{CI95L} Lower bound of the 1-alpha CI for the PD
  \item \code{CI95U} Upper bound of the 1-alpha CI for the PD
  \item \code{alpha} Nominal Type I error rate
}


}
\description{
Testing for the presence of a negligible association between two categorical variables
}
\details{
This function evaluates whether a negligible relationship exists among two categorical variables.

The statistical test is based on the Cramer's V statistic; namely addressing the question of whether the upper limit of the confidence interval for Cramer's V falls below the upper bound of the negligible effect (equivalence) interval (eiU).

If the upper bound of the CI for Cramer's V falls below eiU, we can reject Ho: The relationship is nonnegligible (V >= eiU).

eiU is set to .2 by default, but should be set based on the context of the research. Since Cramer's V statistic is in a correlation metric, setting eiU is a matter of determining what correlation is the minimally meaningful effect size (MMES) given the context of the research.

Users can input either the names of the categorical variables (v1, v2) or a frequency (contingency) table (tab).

The proportional distance (V/eiU) estimates the proportional distance of the effect from 0 to eiU, and acts as an alternative effect size measure.

The confidence interval for the proportional distance is computed via bootstrapping (percentile bootstrap).
}
\examples{
sex<-rep(c("m","f"),c(12,22))
haircol<-rep(c("bld","brn","bld","brn"),c(9,7,11,7))
d <- data.frame(sex,haircol)
tab<-table(sex,haircol)
neg.cat(tab=tab, alpha=.05, nbootpd=50)
neg.cat(v1=sex, v2=haircol, data=d, nbootpd=50)
}
