% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg.rmsea.R
\name{neg.rmsea}
\alias{neg.rmsea}
\alias{print.neg.rmsea}
\title{Equivalence Tests for RMSEA}
\usage{
neg.rmsea(
  mod,
  alpha = 0.05,
  eq.bound,
  modif.eq.bound = FALSE,
  ci.method = "not.close",
  nbootpd = 50L,
  nboot = 250L,
  round = 3,
  plot = TRUE,
  saveplot = FALSE
)

\method{print}{neg.rmsea}(x, ...)
}
\arguments{
\item{mod}{lavaan model object}

\item{alpha}{desired alpha level (default = .05)}

\item{eq.bound}{upper end of equivalence interval for comparison; must be .01, .05, .08 or .10 if modif.eq.bound = TRUE}

\item{modif.eq.bound}{should the upper end of the equivalence interval be modified? (default = FALSE)}

\item{ci.method}{method used to calculate confidence interval; options are "not.close" or "yhy.boot"; "not.close" corresponds to (1-2alpha) percent CI, "yhy.boot" corresponds to (1-2alpha) percent boot CI (default = "not.close")}

\item{nbootpd}{number of bootstrap samples by "yhy.boot" for pd function}

\item{nboot}{number of bootstrap samples if "yhy.boot" is selected as ci.method (default = 250L)}

\item{round}{number of digits to round equivalence bound and confidence interval bounds (default = 3)}

\item{plot}{logical, plotting the results (default = TRUE)}

\item{saveplot}{saving plots (default = FALSE)}

\item{x}{object of class \code{neg.rmsea}}

\item{...}{extra arguments}
}
\value{
returns a \code{list} including the following:
\itemize{
   \item \code{title1} The title of the RMSEA equivalence test. The appropriate title of the test will be displayed depending on the ci.method chosen and whether modif.eq.bound is TRUE or FALSE.
   \item \code{rmsea_index} The RMSEA index.
   \item \code{ci.method} The method for confidence interval calculation (direct computation or bootstrap).
   \item \code{rmsea_eq} The upper end of the 1-2*alpha confidence interval for the RMSEA index.
   \item \code{eq.bound} The equivalence bound.
   \item \code{PD} Proportional distance (PD).
   \item \code{cilpd} Lower bound of the 1-alpha CI for the PD.
   \item \code{ciupd} Upper bound of the 1-alpha CI for the PD.
}
}
\description{
Function performs one of four equivalence tests for RMSEA fit index.
}
\details{
The user specifies the lavaan fitted model object, the desired equivalence bound, and method of confidence interval computation. By default, the function does not modify the equivalence bounds according to Yuan et al. (2016). The user can also choose to instead run an equivalence test using a modified equivalence bound if the equivalence bound to be modified is .01, .05, .08, or .10. Alpha level can also be modified.

For information on modified equivalence bounds see Yuan, K. H., Chan, W., Marcoulides, G. A., & Bentler, P. M. (2016). Assessing structural equation models by equivalence testing with adjusted fit indexes. Structural Equation Modeling: A Multidisciplinary Journal, 23(3), 319-330. doi: https://doi.org/10.1080/10705511.2015.1065414.

The proportional distance quantifies the proportional distance from 0 to the nearest negligible effect (equivalence) interval (here, eiU). As values get farther from 0 the relationship becomes more substantial, with values greater than 1 indicating that the effect falls outside of the negligible effect (equivalence) interval.
}
\examples{
d <- lavaan::HolzingerSwineford1939
hs.mod <- 'visual =~ x1 + x2 + x3
textual =~ x4 + x5 + x6
speed =~ x7 + x8 + x9'
fit1 <- lavaan::cfa(hs.mod, data = d)
neg.rmsea(alpha = .05, mod = fit1, eq.bound = .05, ci.method = "not.close", modif.eq.bound = FALSE,
round = 5, nboot = 50)
}
\author{
Rob Cribbie \email{cribbie@yorku.ca} and
  Nataly Beribisky \email{natalyb1@yorku.ca}

 @export neg.rmsea
}
