% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSPtransitivity.R
\name{OSPtransitivity}
\alias{OSPtransitivity}
\title{Outgoing shared partners mechanism}
\usage{
OSPtransitivity(X, actor)
}
\arguments{
\item{X}{Binary network; of class \code{matrix}.}

\item{actor}{A unit (actor; row/column number), which have an opportunity to change a link.}
}
\value{
A vector with the number of paths of length two between the actor and other units.
}
\description{
Calculates the network statistic according to the outgoing shared partners mechanism.
}
\examples{
X <- matrix(sample(c(0,1), size = 9**2, replace = TRUE), nrow = 9)
OSPtransitivity(X, actor = 2)
}
\references{
Cugmas, M., & Žiberna, A. (2022). Approaches to blockmodeling dynamic networks: a Monte Carlo simulation study. Social Networks, in review.
}
\author{
Marjan Cugmas and Aleš Žiberna
}
