% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assortativity.R
\name{assortativity}
\alias{assortativity}
\title{Assortativity mechanism}
\usage{
assortativity(X, actor)
}
\arguments{
\item{X}{Binary network; of class \code{matrix}.}

\item{actor}{A unit (actor; row/column number), which have an opportunity to change a link.}
}
\value{
A vector with the assortativity mechanism, cacluated between the actor and other units.
}
\description{
Calculate the normalized network statistic according to the assortativity mechanism.
}
\details{
The function returns the value 1 when actor (i.e. ego) and alter do not differ in the number of incoming ties. 
Otherwise, lower values indicate higher difference in the number of incoming ties between the actor and alter.
}
\examples{
X <- matrix(sample(c(0,1), size = 9**2, replace = TRUE), nrow = 9)
mutuality(X, actor = 2)
}
\references{
Cugmas, M., & Žiberna, A. (2022). Approaches to blockmodeling dynamic networks: a Monte Carlo simulation study. Social Networks, in print
}
\author{
Marjan Cugmas and Aleš Žiberna
}
