% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalDensity.R
\name{globalDensity}
\alias{globalDensity}
\title{Network density based on an image matrix and a partition}
\usage{
globalDensity(M, partition)
}
\arguments{
\item{M}{Image matrix with block densities.}

\item{partition}{A partition in a vector format. Each unique value (positive integers) represents one cluster.}
}
\value{
Density of a whole network (a single value).
}
\description{
Based on an image matrix and a partition it calculate the density of a whole network.
}
\examples{
M <- matrix(c(0.1, 0.4, 0.5, 0.3), nrow = 2)
partition <- c(1, 2, 2, 1, 1, 2, 2, 2, 1)
globalDensity(M = M, partition = partition)
}
\author{
Marjan Cugmas
}
