% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nemBM.R
\name{nemBM}
\alias{nemBM}
\title{Network evolution model with a prespecified blockmodel type and partition}
\usage{
nemBM(X = X, partition, M, formula, theta, k = 10000, loops = FALSE)
}
\arguments{
\item{X}{Initial binary network; of class \code{matrix}.}

\item{partition}{A desired partition in a vector format. Each unique value (positive integers) represents one cluster.}

\item{M}{Desired image matrix with block densities.}

\item{formula}{The list of local netork mechanisms to be considered.}

\item{theta}{A vector with the mechanisms' weights/strengths.}

\item{k}{The number of iterations.}

\item{loops}{Wheter loops are allowed or not (default \code{FALSE}).}
}
\value{
The list with the following elements:
\itemize{
\item \code{initialNetwork} - Initial network; of class \code{matrix}.
\item \code{finalNetwork} - Final (generated) network; of class \code{matrix}.
\item \code{formula} - The list of functions that define mechanisms used.
\item \code{theta} - A vector with the mechanisms' weights/strengths used.
\item \code{ERR} - Sum of squared differences between the desired and empirical densities across blocks; for each iteration.
\item \code{iterations} - The number of iterations.
\item \code{loops} - Wheter loops were allowed.
\item \code{M} - The desired (specified) image matrix.
\item \code{partition} - The partition.
\item \code{density} - Network density at each iteration.
\item \code{timeElapsed} - Running time.
}
}
\description{
Generates an asymmetric network with a selected blockmodel type and partition. 
Considers local network mechanisms when creating links within blocks. 
Does not enable considering incomers and outgoers.
}
\examples{
formula <- list(mutuality, popularity, OTPtransitivity)
X <- matrix(sample(c(0,1), size = 9**2, replace = TRUE), nrow = 9)
diag(X) <- 0
M <- matrix(c(0.1, 0.8, 0.1, 0.5), nrow = 2)
partition <- c(1, 2, 2, 1, 1, 2, 2, 2, 1)
res <- nemBM(X = X, partition = partition, formula = formula, 
theta = c(1, 1, 1), M = M, k = 100, loops = FALSE)
}
\references{
Cugmas, M., & Žiberna, A. (2022). Approaches to blockmodeling dynamic networks: a Monte Carlo simulation study. Social Networks, in print.
}
\author{
Marjan Cugmas and Aleš Žiberna
}
