% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/footRaster.R
\name{footRaster}
\alias{footRaster}
\title{Extract eddy covariance footprint data from HDF5 format}
\usage{
footRaster(filepath, progress = TRUE)
}
\arguments{
\item{filepath}{One of: a folder containing NEON EC H5 files, a zip file of DP4.00200.001 data downloaded from the NEON data portal, a folder of DP4.00200.001 data downloaded by the neonUtilities::zipsByProduct() function, or a single NEON EC H5 file. Filepath can only contain files for a single site. [character]}

\item{progress}{T or F: should progress bars be printed? Defaults to TRUE. [logical]}
}
\value{
A rasterStack object containing all the footprints in the input files, plus one layer (the first in the stack) containing the mean footprint.
}
\description{
Create a raster of flux footprint data. Specific to expanded package of eddy covariance data product: DP4.00200.001
For definition of a footprint, see Glossary of Meteorology: https://glossary.ametsoc.org/wiki/Footprint
For background information about flux footprints and considerations around the time scale of footprint calculations, see Amiro 1998: https://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.922.4124&rep=rep1&type=pdf
}
\details{
Given a filepath containing H5 files of expanded package DP4.00200.001 data, extracts flux footprint data and creates a raster.
}
\examples{
\dontrun{
# To run the function on a zip file downloaded from the NEON data portal:
ftprnt <- footRaster(filepath="~/NEON_eddy-flux.zip")
}
}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Claire Lunch \email{clunch@battelleecology.org}
}
