% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHorVer.R
\name{getHorVer}
\alias{getHorVer}
\title{Get the horizontal and vertical location indices for a given data product and site}
\usage{
getHorVer(dpID = NA_character_, site = NA_character_, token = NA_character_)
}
\arguments{
\item{dpID}{The data product ID to get HOR and VER codes for [character]}

\item{site}{The site to get HOR and VER codes for [character]}

\item{token}{User token for the NEON API [character]}
}
\value{
A data frame of HOR and VER indices
}
\description{
Get the available horizontal and vertical location indices for a given data product and site. Only relevant to sensor (IS) data products.
}
\examples{
\dontrun{
# Get the HOR and VER codes for PAR (DP1.00024.001) at Wind River
ind <- getHorVer(dpID="DP1.00024.001", site="WREF")
}
}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Claire Lunch \email{clunch@battelleecology.org}
}
