% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{clean.sites}
\alias{clean.sites}
\title{clean sites objects to remove duplicates.}
\usage{
\method{clean}{sites}(x, verbose = TRUE, ...)
}
\arguments{
\item{x}{sites, datasets, collunits that may have duplicates.}

\item{verbose}{parameter to prints out progress bar}

\item{...}{Additional parameters associated with the call.}
}
\value{
\code{sites} object
}
\description{
Function that removes duplicate objects such as sites,
datasets, or collection units.
}
\examples{
{
clean_sites <- get_sites(sitename = "L\%", limit = 1)
more_sites <- get_sites(sitename = "La\%", limit = 1)
long_set <- c(clean_sites, more_sites)
length(long_set)
# By removing duplicates we get a smaller object.
length(clean(long_set))
}
}
\author{
Simon Goring \email{goring@wisc.edu}
}
