% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.netSEMp1.R
\name{plot.netSEMp1}
\alias{plot.netSEMp1}
\title{Plotting of netSEM diagram}
\usage{
\method{plot}{netSEMp1}(
  x,
  cutoff = c(0.2, 0.5, 0.8),
  latent = NULL,
  plot.save = FALSE,
  filename = NULL,
  style = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class "netSEMp1", the returned list from \code{netSEMp1}. Plotting uses the first element of this list (table) in which the first column of it is endogenous variable, second column is variable and other columns are corresponding best functional form, r-squared, adj-r-squared, P-value1, P-value2 and P-value3.}

\item{cutoff}{A threshold value for adjusted R-squared. The maximum number of cutoff is 3.}

\item{latent}{The latent variable that corresponds to the mechanic variable. The default is NULL.}

\item{plot.save}{True/False, it saves the network diagram plot as a png file. The default is false.}

\item{filename}{A character string naming a file to save as a png file.}

\item{style}{True/False, it plots the first interval in the network diagram with dotted weak line. The default is True.}

\item{...}{A S3 generic/method consistency.}
}
\value{
An html style plot of pairwise relationship pathway diagram between exogenous variables and an endogenous variable. 
Arrows show relationships between each variable with given statistical relations along the connection lines.
}
\description{
Plot netSEMp1 result
plot.netSEMp1 plots a network structural equation network model diagram, fitted under principle 1, based on best functional form for each selected pairwise variable.
}
\examples{
# Load acrylic data set
data(acrylic)

# Build a netSEM model
ans <- netSEMp1(acrylic)

# Plot the network model 
plot(ans,cutoff = c(0.3,0.6,0.8))

# Plot the network diagram with latent argument labels
plot(ans, cutoff = c(0.3, 0.6, 0.8), 
     latent = c('IAD1' = 'FundAbsEdge', 
                'IAD2' = 'UVStab', 
                'IAD2p' = 'UVStab', 
                'IAD3' = 'YelMet'))

# Drop relationships lower than minimum cutoff value
plot(ans, cutoff = c(0.3,0.6,0.8), style = FALSE)

\dontrun{
# Save plot 
plot(ans, cutoff = c(0.3, 0.6, 0.8), plot.save = TRUE, filename = 'acrylic-netSEMp1')
}
}
\seealso{
\link[netSEM]{netSEMp1}
}
