% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grow_SW.R
\name{grow_SW}
\alias{grow_SW}
\title{Grow a Small-World Network}
\usage{
grow_SW(matrix, x, rewire, connected = FALSE, retcon = FALSE, directed = TRUE)
}
\arguments{
\item{matrix}{Existing network to experience growth.}

\item{x}{The ID of the node to be grown.}

\item{rewire}{Small-World parameter specifying the probability each edge is randomly rewired, allowing for the possiblity of bridges between connected communities.}

\item{connected}{Binary argument determining if the newly grown node has to be connected to the existing network. Defaults to FALSE, to prevent rare computational slow-downs when it is unlikely to create a connected network. Defaults to False.}

\item{retcon}{Binary variable determining if already existing nodes can attach to new nodes. Defaults to FALSE.}

\item{directed}{Binary variable determining if the network is directed, resulting in off-diagonal asymmetry in the adjacency matrix. Defaults to TRUE.}
}
\value{
An adjacency matrix.
}
\description{
Grows an already existing network by adding a node according to the Small-World mechanism. Nodes can only attach to previously grown nodes.
}
\details{
Grows a node in a network according to the Small-World mechanism.
}
\examples{
# Import netcom
library(netcom)

size <- 10
existing_network <- matrix(sample(c(0,1), size = size^2, replace = TRUE), nrow = size, ncol = size)
new_network_prep <- matrix(0, nrow = size + 1, ncol = size + 1)
new_network_prep[1:size, 1:size] = existing_network
new_network <- grow_SW(matrix = new_network_prep, x = size + 1, rewire = 0.213)

}
\references{
Watts, D. J., & Strogatz, S. H. (1998). Collective dynamics of ‘small-world’networks. nature, 393(6684), 440-442.
}
