% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{dgr}
\alias{degree}
\alias{dgr}
\alias{indegree}
\alias{outdegree}
\title{Indegree, outdegree and degree of the vertices}
\usage{
dgr(graph, cmode = "degree", undirected = getOption("diffnet.undirected",
  FALSE), self = getOption("diffnet.self", FALSE),
  valued = getOption("diffnet.valued", FALSE))
}
\arguments{
\item{graph}{Any class of accepted graph format (see \code{\link{netdiffuseR-graphs}}).}

\item{cmode}{Character scalar. Either "indegree", "outdegree" or "degree".}

\item{undirected}{Logical scalar. TRUE when the graph is undirected.}

\item{self}{Logical scalar.. TRUE when self edges should not be considered.}

\item{valued}{Logical scalar. When FALSE sets every non-zero entry of \code{graph} to one.}
}
\value{
Either a numeric vector of size \eqn{n}{n} with the degree of each node (if graph is
a matrix), or a matrix of size \eqn{n\times T}{n * T}.
}
\description{
Computes the requested degree measure for each node in the graph.
}
\examples{

# Comparing degree measurements ---------------------------------------------
# Creating an undirected graph
graph <- rgraph_ba()
graph

data.frame(
   In=dgr(graph, "indegree", undirected = FALSE),
   Out=dgr(graph, "outdegree", undirected = FALSE),
   Degree=dgr(graph, "degree", undirected = FALSE)
 )

# Testing on Korean Family Planning (weighted graph) ------------------------
data(kfamilyDiffNet)
d_unvalued <- dgr(kfamilyDiffNet, valued=FALSE)
d_valued   <- dgr(kfamilyDiffNet, valued=TRUE)

any(d_valued!=d_unvalued)

}
\author{
Vega Yon
}
\seealso{
Other statistics: \code{\link{cumulative_adopt_count}},
  \code{\link{exposure}}, \code{\link{hazard_rate}},
  \code{\link{infection}}, \code{\link{moran}},
  \code{\link{struct_equiv}}, \code{\link{threshold}}
}
\keyword{univar}

