% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struct_equiv.R
\name{struct_equiv}
\alias{struct_equiv}
\title{Structural Equivalence}
\usage{
struct_equiv(graph, v = 1, inf.replace = 0, ...)
}
\arguments{
\item{graph}{Any class of accepted graph format (see \code{\link{netdiffuseR-graphs}}).}

\item{v}{Numeric scalar. Cohesion constant (see details).}

\item{inf.replace}{Logical scalar. Passed to \code{\link[sna:geodist]{sna::geodist}}.}

\item{...}{Further arguments to be passed to \code{\link[sna:geodist]{sna::geodist}}.}
}
\value{
If \code{graph} is a static graph, a list with the following elements:
\item{\code{SE}}{Numeric Matrix of size \eqn{n\times n}{n * n} with Structural equivalence}
\item{\code{d}}{Numeric Matrix of size \eqn{n\times n}{n * n} Euclidean distances}
\item{\code{gdis}}{Numeric Matrix of size \eqn{n\times n}{n * n} Normalized geodesic distance}
In the case of dynamic graph, is a list of size \code{t} in which each element
contains a list as described before.
}
\description{
Computes structural equivalence between ego and alter in a network
}
\details{
Structure equivalence is computed as presented in Valente (1995), and Burt (1987),
in particular

\deqn{%
SE_{ij} = \frac{(dmax_i - d_{ji})^v}{\sum_{k\neq i}^n(dmax_i-d_{ki})^v}
}{%
SE(ij) = [dmax(i) - d(ji)]^v/[\sum_k (dmax(i) - d(ki))^v]
}

with the summation over \eqn{k\neq i}{k!=i}, and \eqn{d_{ji}}{d(ji)}, Eucledian distance in terms of geodesics, is defined as

\deqn{%
d_{ji} = \left[(z_{ji} - z_{ij})^2 + \sum_k^n (z_{jk} - z_{ik})^2 +  \sum_k^n (z_{ki} - z_{kj})^2\right]^\frac{1}{2}
}{%
d(ji) = [(z(ji) - z(ij))^2 + \sum_k (z(jk) - z(ik))^2 +  \sum_k (z_(ki) - z_(kj))^2]^(1/2)
}

with \eqn{z_{ij}}{z(ij)} as the geodesic (shortest path) from \eqn{i} to \eqn{j}, and
\eqn{dmax_i}{dmax(i)} equal to largest Euclidean distance between \eqn{i} and any other
vertex in the network. All summations are made over \eqn{k\not\in \{i,j\}}{k!={i,j}}

Here, the value of \eqn{v} is interpreted as cohesion level. The higher its value,
the higher will be the influence that the closests alters will have over ego (see
Burt's paper in the reference).
}
\author{
Vega Yon, Dyal, Hayes & Valente
}
\references{
Burt, R. S. (1987). "Social Contagion and Innovation: Cohesion versus
Structural Equivalence". American Journal of Sociology, 92(6), 1287–1335.
\url{http://doi.org/10.1086/228667}

Valente, T. W. (1995). "Network models of the diffusion of innovations" (2nd ed.).
Cresskill N.J.: Hampton Press.
}
\seealso{
Other statistics: \code{\link{cumulative_adopt_count}},
  \code{\link{dgr}}, \code{\link{exposure}},
  \code{\link{hazard_rate}}, \code{\link{infection}},
  \code{\link{moran}}, \code{\link{threshold}}
}
\keyword{univar}

