% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjmat.R
\name{toa_diff}
\alias{toa_diff}
\title{Difference in Time of Adoption (TOA) between individuals}
\usage{
toa_diff(obj, t0 = NULL, labels = NULL)
}
\arguments{
\item{obj}{Either an integer vector of size \eqn{n} containing time of adoption of the innovation,
or a \code{\link{diffnet}} object.}

\item{t0}{Integer scalar. Sets the lower bound of the time window (e.g. 1955).}

\item{labels}{Character vector of size \eqn{n}. Labels (ids) of the vertices.}
}
\value{
An \eqn{n \times n}{n * n} symmetric matrix indicating the difference in times of
adoption between each pair of nodes.
}
\description{
Creates \eqn{n \times n}{n * n} matrix indicating the difference in times of adoption between
each pair of nodes
}
\details{
Each cell ij of the resulting matrix is calculated as \eqn{toa_j - toa_i}{%
toa(j) - toa(i)}, so that whenever its positive it means that the j-th individual (alter)
adopted the innovation sonner.
}
\examples{
# Generating a random vector of time
set.seed(123)
times <- sample(2000:2005, 10, TRUE)

# Computing the TOA differences
toa_diff(times)
}
\author{
Vega Yon, Dyal, Hayes & Valente
}
\keyword{manip}

