% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igraph.R
\name{diffnet_to_igraph}
\alias{diffnet_to_igraph}
\alias{igraph_to_diffnet}
\title{Convertion between graph classes}
\usage{
diffnet_to_igraph(graph, slices = 1:nslices(graph))

igraph_to_diffnet(graph, toavar, t0 = NULL, t1 = NULL, ...)
}
\arguments{
\item{graph}{Either a \code{\link{diffnet}} or \code{\link[igraph:igraph]{igraph}} graph object.}

\item{slices}{An integer vector indicating the slices to subset.}

\item{toavar}{Character scalar. Name of the attribute that holds the times of adoption.}

\item{t0}{Integer scalar. Passed to \code{\link{as_diffnet}}.}

\item{t1}{Integer scalar. Passed to \code{\link{as_diffnet}}.}

\item{...}{Further arguments passed to \code{\link{as_diffnet}}.}
}
\value{
Either a list of \code{length(slices)} \code{igraph}
(\code{diffnet_to_igraph}), or a \code{diffnet} object (\code{igraph_to_diffnet})
objects.
}
\description{
Convertion between graph classes
}
\examples{
# Reading the meddical innovation data into igraph --------------------------
x <- diffnet_to_igraph(medInnovationsDiffNet)

# Fetching the times of adoption
igraph::vertex_attr(x[[1]], "toa")

}
\seealso{
Other graph formats: \code{\link{netdiffuseR-graphs}},
  \code{\link{read_pajek}}, \code{\link{read_ucinet_head}}
}

