% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-methods.r
\name{plot_diffnet}
\alias{plot_diffnet}
\alias{plot_diffnet.diffnet}
\alias{plot_diffnet.default}
\title{Plot the diffusion process}
\usage{
plot_diffnet(...)

\method{plot_diffnet}{diffnet}(graph, ...)

\method{plot_diffnet}{default}(graph, cumadopt, slices = NULL,
  vertex.color = c("white", "tomato", "steelblue"),
  vertex.shape = c("square", "circle", "circle"), vertex.size = "degree",
  mfrow.par = NULL, main = c("Network in period \%s", "Diffusion Network"),
  legend.args = list(),
  minmax.relative.size = getOption("diffnet.minmax.relative.size", c(0.01,
  0.04)), background = grDevices::gray(0.9), ...)
}
\arguments{
\item{...}{Further arguments to be passed to \code{\link[igraph:plot.igraph]{plot.igraph}}.}

\item{graph}{A dynamic graph (see \code{\link{netdiffuseR-graphs}}).}

\item{cumadopt}{\eqn{n\times T}{n*T} matrix.}

\item{slices}{Integer vector. Indicates what slices to plot. By default all are plotted.}

\item{vertex.color}{A character vector of size 3 with colors names.}

\item{vertex.shape}{A character vector of size 3 with shape names.}

\item{vertex.size}{Either a numeric scalar or vector of size \eqn{n}, or any
of the following values: "indegree", "degree", or "outdegree" (see details).}

\item{mfrow.par}{Vector of size 2 with number of rows and columns to be passed to \code{\link{par}.}}

\item{main}{Character scalar. A title template to be passed to \code{\link{sprintf}.}}

\item{legend.args}{List of arguments to be passed to \code{\link{legend}}.}

\item{minmax.relative.size}{Passed to \code{\link{rescale_vertex_igraph}}.}

\item{background}{Either a function to be called before plotting each slice, a color
to specify the backgroupd color, or \code{NULL} (in which case nothing is done).}
}
\value{
Calculated coordinates for the grouped graph (invisible).
}
\description{
Creates a colored network plot showing the structure of the graph through time
(one network plot for each time period)  and the set of adopter and non-adopters
in the network.
}
\details{
Plotting is done via the function \code{\link[igraph:plot.igraph]{plot.igraph}}.

When \code{vertex.size} is either of \code{"degree"}, \code{"indegree"}, or
\code{"outdegree"}, \code{vertex.size} will be replace with \code{dgr(.,cmode = )}
so that the vertex size reflects the desired degree.

The argument \code{minmax.relative.size} is passed to \code{\link{rescale_vertex_igraph}}
which adjusts \code{vertex.size} so that the largest and smallest vertices
have a relative size of \code{minmax.relative.size[2]} and
\code{minmax.relative.size[1]} respectively with respect to the x-axis.

Plotting is done via the function \code{\link[igraph:plot.igraph]{plot.igraph}}.

In order to center the attention on the diffusion process itself, the
positions of each vertex are computed only once by aggregating the networks
through time, this is, instead of computing the layout for each time \eqn{t},
the function creates a new graph accumulating links through time.

The \code{mfrow.par} sets how to arrange the plots on the device. If \eqn{T=5}
and \code{mfrow.par=c(2,3)}, the first three networks will be in the top
of the device and the last two in the bottom.

The argument \code{vertex.color} contains the colors of non-adopters, new-adopters,
and adopters respectively. The new adopters (default color \code{"tomato"}) have a different
color that the adopters when the graph is at their time of adoption, hence,
when the graph been plotted is in \eqn{t=2} and \eqn{toa=2} the vertex will
be plotted in red.

\code{legend.args} has the following default parameter:
\tabular{ll}{
  \code{x} \tab \code{"bottom"} \cr
  \code{legend} \tab \code{c("Non adopters", "New adopters","Adopters")} \cr
  \code{pch} \tab \code{sapply(vertex.shape, switch, circle = 21, square = 22, 21)} \cr
  \code{bty} \tab \code{"n"} \cr
  \code{horiz} \tab \code{TRUE} \cr
}
}
\examples{
# Generating a random graph
set.seed(1234)
n <- 6
nper <- 5
graph <- rgraph_er(n,nper, p=.3, undirected = FALSE)
toa <- sample(2000:(2000+nper-1), n, TRUE)
adopt <- toa_mat(toa)

plot_diffnet(graph, adopt$cumadopt)
}
\seealso{
Other visualizations: \code{\link{dgr}},
  \code{\link{diffusionMap}}, \code{\link{drawColorKey}},
  \code{\link{grid_distribution}},
  \code{\link{hazard_rate}}, \code{\link{plot_adopters}},
  \code{\link{plot_diffnet2}},
  \code{\link{plot_infectsuscep}},
  \code{\link{plot_threshold}},
  \code{\link{rescale_vertex_igraph}}
}
\author{
George G. Vega Yon
}
\keyword{hplot}
