% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey_to_diffnet.R
\name{survey_to_diffnet}
\alias{survey_to_diffnet}
\alias{edgelist_to_diffnet}
\title{Convert survey-like data and edgelists to a \code{diffnet} object}
\usage{
survey_to_diffnet(dat, idvar, netvars, toavar, groupvar = NULL,
  no.unsurveyed = TRUE, timevar = NULL, t = NULL,
  undirected = getOption("diffnet.undirected", FALSE),
  self = getOption("diffnet.self", FALSE),
  multiple = getOption("diffnet.multiple", FALSE), keep.isolates = TRUE,
  recode.ids = TRUE, warn.coercion = TRUE, ...)

edgelist_to_diffnet(edgelist, w = NULL, t0 = NULL, t1 = NULL, dat, idvar,
  toavar, timevar = NULL, undirected = getOption("diffnet.undirected",
  FALSE), self = getOption("diffnet.self", FALSE),
  multiple = getOption("diffnet.multiple", FALSE), fill.missing = NULL,
  keep.isolates = TRUE, recode.ids = TRUE, warn.coercion = TRUE)
}
\arguments{
\item{dat}{A data frame.}

\item{idvar}{Character scalar. Name of the id variable.}

\item{netvars}{Character vector. Names of the network nomination variables.}

\item{toavar}{Character scalar. Name of the time of adoption variable.}

\item{groupvar}{Character scalar. Name of cohort variable (e.g. city).}

\item{no.unsurveyed}{Logical scalar. When \code{TRUE} the nominated individuals
that do not show in \code{idvar} are set to \code{NA} (see details).}

\item{timevar}{Character sacalar. In the case of longitudinal data, name of the time var.}

\item{t}{Integer scalar. Repeat the network \code{t} times (if no \code{t0,t1} are provided).}

\item{undirected}{Logical scalar. When \code{TRUE} only the lower triangle of the adjacency matrix will considered (faster).}

\item{self}{Logical scalar. When \code{TRUE} autolinks (loops, self edges) are allowed (see details).}

\item{multiple}{Logical scalar. When \code{TRUE} allows multiple edges.}

\item{keep.isolates}{Logical scalar. When FALSE, rows with \code{NA/NULL} values
(isolated vertices unless have autolink) will be droped (see details).}

\item{recode.ids}{Logical scalar. When TRUE ids are recoded using \code{\link{as.factor}}
(see details).}

\item{warn.coercion}{Logical scalar. When \code{TRUE} warns coercion from numeric to integer.}

\item{...}{Further arguments to be passed to \code{\link{new_diffnet}}.}

\item{edgelist}{Two column matrix/data.frame in the form of ego -source- and
alter -target- (see details).}

\item{w}{Numeric vector. Strength of ties (optional).}

\item{t0}{Integer vector. Starting time of the ties (optional).}

\item{t1}{Integer vector. Finishing time of the ties (optional).}

\item{fill.missing}{Character scalar. In the case of having unmatching ids
between \code{dat} and \code{edgelist}, fills the data (see details).}
}
\value{
A \code{\link{diffnet}} object.
}
\description{
These convenient functions turn network nomination datasets and edgelists with
vertex attributes datasets into diffnet objects. Both work as wrappers of
\code{\link{edgelist_to_adjmat}} and \code{\link{new_diffnet}}.
}
\details{
All of \code{netvars}, \code{toavar} and \code{groupvar}
must be integers. Were these numeric they are coerced into integers, otherwise,
when neither of both, the function returns with error. \code{idvar}, on the
other hand, should only be integer when calling \code{survey_to_diffnet},
on the contrary, for \code{edgelist_to_diffnet}, \code{idvar} may be character.

In field work it is not unusual that some respondents nominate unsurveyed
individuals. In such case, in order to exclude them from the analysis,
the user can set \code{no.unsurveyed=TRUE} (the default), telling the
function to exclude such individuals from the adjacency matrix. This is
done by setting variables in \code{netvars} equal to \code{NA} when the
nominated id can't be found in \code{idvar}.

If the network nomination process was done in different groups (location
for example) the survey id numbers may be define uniquely within each group
but not across groups (there may be many individuals with \code{id=1},
for example). To encompass this issue, the user can tell the function what
variable can be used to distinguish between groups through the \code{groupvar}
argument. When \code{groupvar} is provided, function redifines \code{idvar}
and the variables in \code{netvars} as follows:

\preformatted{
   dat[[idvar]] <- dat[[idvar]] + dat[[groupvar]]*z
}

Where \code{z = 10^nchar(max(dat[[idvar]]))}.

For longitudinal data, it is assumed that the \code{toavar} holds the same
information through time, this is, time-invariable. This as the package does
not yet support variable times of adoption.

The \code{fill.missing} option can take any of these three values: \code{"edgelist"},
\code{"dat"}, or \code{"both"}. This argument works as follows:
\enumerate{
   \item When \code{fill.missing="edgelist"} (or \code{"both"}) the function
   will check which vertices show in \code{dat} but do not show in \code{edgelist}.
   If there is any, the function will include these in \code{edgelist} as ego to
   \code{NA} (so they have no link to anyone), and, if specified, will fill
   the \code{t0}, \code{t1} vectors with \code{NA}s for those cases. If
   \code{w} is also specified, the new vertices will be set to
   \code{min(w, na.rm=TRUE)}.
   \item When \code{fill.missing="dat"} (or \code{"both"}) the function
   checks which vertices show in \code{edgelist} but not in \code{dat}. If
   there is any, the function will include these in \code{dat} by adding
   one row per individual.
}
}
\examples{
# Loading a fake survey (data frame)
data(fakesurvey)

# Diffnet object keeping isolated vertices ----------------------------------
dn1 <- survey_to_diffnet(fakesurvey, "id", c("net1", "net2", "net3"), "toa",
   "group", keep.isolates=TRUE)

# Diffnet object NOT keeping isolated vertices
dn2 <- survey_to_diffnet(fakesurvey, "id", c("net1", "net2", "net3"), "toa",
   "group", keep.isolates=FALSE)

# dn1 has an extra vertex than dn2
dn1
dn2

# Loading a longitudinal survey data (two waves) ----------------------------
data(fakesurveyDyn)

groupvar <- "group"
x <- survey_to_diffnet(
   fakesurveyDyn, "id", c("net1", "net2", "net3"), "toa", "group" ,
   timevar = "time", keep.isolates = TRUE, warn.coercion=FALSE)

plot_diffnet(x, vertex.label = rownames(x))

# Reproducing medInnovationsDiffNet object ----------------------------------
data(medInnovations)

# What are the netvars
netvars <- names(medInnovations)[grepl("^net", names(medInnovations))]

medInnovationsDiffNet2 <- survey_to_diffnet(
   medInnovations,
   "id", netvars, "toa", "city",
   warn.coercion=FALSE)

medInnovationsDiffNet2

# Comparing with the package's version
all(diffnet.toa(medInnovationsDiffNet2) == diffnet.toa(medInnovationsDiffNet)) #TRUE
all(
   diffnet.attrs(medInnovationsDiffNet2, as.df = TRUE) ==
   diffnet.attrs(medInnovationsDiffNet, as.df = TRUE),
   na.rm=TRUE) #TRUE


}
\seealso{
\code{\link{fakesurvey}}, \code{\link{fakesurveyDyn}}

Other data management functions: \code{\link{diffnet-class}},
  \code{\link{edgelist_to_adjmat}},
  \code{\link{egonet_attrs}}, \code{\link{isolated}}
}
\author{
Vega Yon
}
