% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rewire.r
\name{permute_graph}
\alias{permute_graph}
\alias{CUG}
\alias{QAP}
\alias{rewire_permute}
\alias{rewire_qap}
\title{Permute the values of a matrix}
\usage{
permute_graph(graph, self = FALSE, multiple = FALSE)

rewire_permute(graph, self = FALSE, multiple = FALSE)

rewire_qap(graph)
}
\arguments{
\item{graph}{Any class of accepted graph format (see \code{\link{netdiffuseR-graphs}}).}

\item{self}{Logical scalar. When \code{TRUE} autolinks (loops, self edges) are allowed (see details).}

\item{multiple}{Logical scalar. When \code{TRUE} allows multiple edges.}
}
\value{
A permuted version of \code{graph}.
}
\description{
\code{permute_graph} Shuffles the values of a matrix either considering
\emph{loops} and \emph{multiple} links (which are processed as cell values
different than 1/0). \code{rewire_qap} generates a new graph \code{graph}\eqn{'}
that is isomorphic to \code{graph}.
}
\examples{
# Simple example ------------------------------------------------------------
set.seed(1231)
g <- rgraph_ba(t=9)
g

# These preserve the density
permute_graph(g)
permute_graph(g)

# These are isomorphic to g
rewire_qap(g)
rewire_qap(g)

}
\references{
Anderson, B. S., Butts, C., & Carley, K. (1999). The interaction of size and
density with graph-level indices. Social Networks, 21(3), 239–267.
\doi{10.1016/S0378-8733(99)00011-8}

Mantel, N. (1967). The detection of disease clustering and a generalized
regression approach. Cancer Research, 27(2), 209–20.
}
\seealso{
This function can be used as null distribution in \code{struct_test}

Other simulation functions: 
\code{\link{rdiffnet}()},
\code{\link{rewire_graph}()},
\code{\link{rgraph_ba}()},
\code{\link{rgraph_er}()},
\code{\link{rgraph_ws}()},
\code{\link{ring_lattice}()}
}
\author{
George G. Vega Yon
}
\concept{simulation functions}
