% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dynamise.R
\name{dynamise}
\alias{dynamise}
\title{Add dynamic arrival times to nodes.}
\usage{
dynamise(x, n.dynamic = NULL, dyn.customers.ratio = NULL, arrival.limit)
}
\arguments{
\item{x}{[\code{Network}]\cr
Network.}

\item{n.dynamic}{[integer(1) | NULL]
Number of nodes, which should become dynamic. Ignored if \code{dyn.customers.ratio}
is not \code{NULL}.}

\item{dyn.customers.ratio}{[numeric(1) | NULL]
Ratio of dynamic nodes. If this is set to a numeric value in (0, 1), the
parameter \code{n.dynamic} is ignored.}

\item{arrival.limit}{[numeric(1)]\cr
Maximal arrival time.}
}
\value{
[\code{Network}]
  Modified network (now has an additional list element 'arrival.times') and the
  ratio of dynamic customers as an attribute.
}
\description{
Some variants of the Vehicle Routing Problem (VRP) consider static as well
as dynamic customers (nodes). This function takes a \code{Network} and
dynamises it, i. e., it adds dynamic arrival times to the customers via a
Poisson process.
}
\examples{
x = generateClusteredNetwork(n.points = 100L, n.cluster = 4L, upper = 100, n.depots = 2L)
x = dynamise(x, dyn.customers.ratio = 0.3, arrival.limit = 400)
print(x)
}
\seealso{
\code{\link{generateRandomNetwork}}, \code{\link{generateClusteredNetwork}},
\code{\link{generateGridNetwork}}
}

