% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/visualizeMorphing.R
\name{visualizeMorphing}
\alias{visualizeMorphing}
\title{Fancy visualization of morphing.}
\usage{
visualizeMorphing(x, y, point.matching = NULL, alphas = c(0.25, 0.5, 0.75),
  arrows = TRUE, in.one.plot = TRUE)
}
\arguments{
\item{x}{[\code{Network}]\cr
First network.}

\item{y}{[\code{Network}]\cr
Second network.}

\item{point.matching}{[\code{matrix}]\cr
Point matching which shall be used for morphing. If \code{NULL}, an optimal
point matching is generated via function \code{\link{getOptimalPointMatching}}.
Default is \code{NULL}.}

\item{alphas}{[\code{numeric}]\cr
Vector of coefficients 'alpha' for convex combinations.}

\item{arrows}{[\code{logical(1)}]\cr
Draw arrows originating in the points of \code{x} and ending in the
points matched in \code{y}. Default is \code{TRUE}.}

\item{in.one.plot}{[\code{logical(1)}]\cr
Currently the function offers two different types of plot. If \code{in.one.plot}
is \code{TRUE}, which is the default value, the morphing is dipicted in one plot.
This is in particular useful for small instances. If set to \code{FALSE},
a matrix of plots is generated via \code{\link[ggplot2]{facet_grid}}. One
plot for each alpha value in \code{alphas}.}
}
\value{
[\code{\link[ggplot2]{ggplot}}]
}
\description{
Takes two instances of equal size and some alpha values. Computes the point matching
and morphings for the alpha values and visualizes the transition of points
of the first instance towards their matched counterparts of the second instance
with two different methods.
}
\seealso{
\code{\link{morphInstances}}
}

