% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.netmeta.R
\name{summary.netmeta}
\alias{summary.netmeta}
\alias{print.summary.netmeta}
\title{Print and summary method for objects of class netmeta}
\usage{
\method{summary}{netmeta}(
  object,
  comb.fixed = object$comb.fixed,
  comb.random = object$comb.random,
  prediction = object$prediction,
  reference.group = object$reference.group,
  baseline.reference = object$baseline.reference,
  all.treatments = object$all.treatments,
  ...
)

\method{print}{summary.netmeta}(
  x,
  comb.fixed = x$comb.fixed,
  comb.random = x$comb.random,
  prediction = x$prediction,
  reference.group = x$reference.group,
  baseline.reference = x$baseline.reference,
  all.treatments = x$all.treatments,
  backtransf = x$backtransf,
  nchar.trts = x$nchar.trts,
  header = TRUE,
  digits = gs("digits"),
  digits.stat = gs("digits.stat"),
  digits.pval = max(gs("digits.pval"), 2),
  digits.pval.Q = max(gs("digits.pval.Q"), 2),
  digits.Q = gs("digits.Q"),
  digits.tau2 = gs("digits.tau2"),
  digits.tau = gs("digits.tau"),
  digits.I2 = gs("digits.I2"),
  scientific.pval = gs("scientific.pval"),
  big.mark = gs("big.mark"),
  text.tau2 = gs("text.tau2"),
  text.tau = gs("text.tau"),
  text.I2 = gs("text.I2"),
  legend = TRUE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{netmeta}.}

\item{comb.fixed}{A logical indicating whether results for the
fixed effects (common effects) model should be printed.}

\item{comb.random}{A logical indicating whether results for the
random effects model should be printed.}

\item{prediction}{A logical indicating whether prediction intervals
should be printed.}

\item{reference.group}{Reference treatment.}

\item{baseline.reference}{A logical indicating whether results
should be expressed as comparisons of other treatments versus the
reference treatment (default) or vice versa. This argument is
only considered if \code{reference.group} has been specified.}

\item{all.treatments}{A logical or \code{"NULL"}. If \code{TRUE},
matrices with all treatment effects, and confidence limits will
be printed.}

\item{\dots}{Additional arguments.}

\item{x}{An object of class \code{summary.netmeta}.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and forest plots. If
\code{backtransf = TRUE}, results for \code{sm = "OR"} are
presented as odds ratios rather than log odds ratios, for
example.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names.}

\item{header}{A logical indicating whether information on title of
meta-analysis, comparison and outcome should be printed at the
beginning of the printout.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.stat}{Minimal number of significant digits for tests
of overall effect, see \code{print.default}.}

\item{digits.pval}{Minimal number of significant digits for p-value
of overall effects, see \code{print.default}.}

\item{digits.pval.Q}{Minimal number of significant digits for
p-value of heterogeneity tests, see \code{print.default}.}

\item{digits.Q}{Minimal number of significant digits for
heterogeneity statistics, see \code{print.default}.}

\item{digits.tau2}{Minimal number of significant digits for
between-study variance, see \code{print.default}.}

\item{digits.tau}{Minimal number of significant digits for square
root of between-study variance, see \code{print.default}.}

\item{digits.I2}{Minimal number of significant digits for I-squared
statistic, see \code{print.default}.}

\item{scientific.pval}{A logical specifying whether p-values should
be printed in scientific notation, e.g., 1.2345e-01 instead of
0.12345.}

\item{big.mark}{A character used as thousands separator.}

\item{text.tau2}{Text printed to identify between-study variance
\eqn{\tau^2}.}

\item{text.tau}{Text printed to identify \eqn{\tau}, the square
root of the between-study variance \eqn{\tau^2}.}

\item{text.I2}{Text printed to identify heterogeneity statistic
I\eqn{^2}.}

\item{legend}{A logical indicating whether a legend should be
printed.}
}
\value{
A list is returned with the following elements:
\item{comparison}{Results for pairwise comparisons (data frame with
  columns studlab, treat1, treat2, TE, seTE, lower, upper, z, p).}
\item{comparison.nma.fixed}{Results for pairwise comparisons based
  on fixed effects model (data frame with columns studlab, treat1,
  treat2, TE, seTE, lower, upper, z, p, leverage).}
\item{comparison.nma.random}{Results for pairwise comparisons based
  on random effects model (data frame with columns studlab, treat1,
  treat2, TE, seTE, lower, upper, z, p).}
\item{fixed}{Results for fixed effects model (a list with elements
  TE, seTE, lower, upper, z, p).}
\item{random}{Results for random effects model (a list with
  elements TE, seTE, lower, upper, z, p).}
\item{predict}{Prediction intervals (a list with elements seTE,
  lower, upper).}
\item{studies}{Study labels coerced into a factor with its levels
  sorted alphabetically.}
\item{narms}{Number of arms for each study.}
\item{k}{Total number of studies.}
\item{m}{Total number of pairwise comparisons.}
\item{n}{Total number of treatments.}
\item{d}{Total number of designs (corresponding to the unique set
  of treatments compared within studies).}
\item{Q}{Overall heterogeneity / inconsistency statistic.}
\item{df.Q}{Degrees of freedom for test of heterogeneity /
  inconsistency.}
\item{pval.Q}{P-value for test of heterogeneity / inconsistency.}
\item{I2, lower.I2, upper.I2}{I-squared, lower and upper confidence
  limits.}
\item{tau}{Square-root of between-study variance.}
\item{Q.heterogeneity}{Overall heterogeneity statistic.}
\item{df.Q.heterogeneity}{Degrees of freedom for test of overall
  heterogeneity.}
\item{pval.Q.heterogeneity}{P-value for test of overall
  heterogeneity.}
\item{Q.inconsistency}{Overall inconsistency statistic.}
\item{df.Q.inconsistency}{Degrees of freedom for test of overall
  inconsistency.}
\item{pval.Q.inconsistency}{P-value for test of overall
  inconsistency.}
\item{sm}{A character string indicating underlying summary
  measure.}
\item{method}{A character string indicating which method is to be
  used for pooling of studies.}
\item{level}{The level used to calculate confidence intervals for
  individual studies.}
\item{level.comb}{The level used to calculate confidence intervals
  for pooled estimates.}
\item{comb.fixed, comb.random}{As defined above.}
\item{prediction, level.predict}{As defined above.}
\item{reference.group, baseline.reference}{As defined above.}
\item{all.treatments, backtransf}{As defined above.}
\item{ci.lab}{Label for confidence interval.}
\item{seq}{A character specifying the sequence of treatments.}
\item{tau.preset}{An optional value for the square-root of the
  between-study variance \eqn{\tau^2}.}
\item{sep.trts}{A character used in comparison names as separator
  between treatment labels.}
\item{nchar.trts}{A numeric defining the minimum number of
  characters used to create unique treatment names.}
\item{title}{Title of meta-analysis / systematic review.}
\item{call}{Function call.}
\item{version}{Version of R package netmeta used to create object.}
}
\description{
Print and summary method for objects of class \code{netmeta}.
}
\examples{
data(Senn2013)

# Conduct fixed effects network meta-analysis
#
net1 <- netmeta(TE, seTE, treat1, treat2, studlab,
                data = Senn2013, sm = "MD",
                comb.random = FALSE)
print(net1, ref = "plac", digits = 3)
summary(net1)

\dontrun{
# Conduct random effects network meta-analysis
#
net2 <- netmeta(TE, seTE, treat1, treat2, studlab,
                data = Senn2013, sm = "MD",
                comb.fixed = FALSE)
print(net2, ref = "plac", digits = 3)
summary(net2)
}

}
\seealso{
\code{\link{netmeta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{print}
