% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netbind.R
\name{netbind}
\alias{netbind}
\title{Combine network meta-analysis objects}
\usage{
netbind(
  ...,
  name,
  common,
  random,
  col.study = "black",
  col.inside = "white",
  col.square = "gray",
  col.square.lines = col.square,
  backtransf,
  reference.group,
  baseline.reference,
  warn.deprecated = gs("warn.deprecated"),
  fixed,
  comb.fixed,
  comb.random
)
}
\arguments{
\item{\dots}{Any number of network meta-analysis objects or a
single list with network meta-analyses.}

\item{name}{An optional character vector providing descriptive
names for network meta-analysis objects.}

\item{common}{A logical indicating whether results for the common
effects model should be reported.}

\item{random}{A logical indicating whether results for the random
effects model should be reported.}

\item{col.study}{The colour for network estimates and confidence
limits.}

\item{col.inside}{The colour for network estimates and confidence
limits if confidence limits are completely within squares.}

\item{col.square}{The colour for squares.}

\item{col.square.lines}{The colour for the outer lines of squares.}

\item{backtransf}{A logical indicating whether results should be
back transformed. If \code{backtransf = TRUE} (default), results
for \code{sm = "OR"} are printed as odds ratios rather than log
odds ratios, for example.}

\item{reference.group}{Reference treatment.}

\item{baseline.reference}{A logical indicating whether results
should be expressed as comparisons of other treatments versus the
reference treatment (default) or vice versa. This argument is
only considered if \code{reference.group} has been specified.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{fixed}{Deprecated argument; replaced by \code{common}.}

\item{comb.fixed}{Deprecated argument; replaced by \code{common}.}

\item{comb.random}{Deprecated argument; replaced by \code{random}.}
}
\value{
An object of class \code{"netbind"} with corresponding
\code{forest} function. The object is a list containing the
following components:
\item{common}{A data frame with results for the common effects
  model.}
\item{random}{A data frame with results for the random effects
  model.}
\item{sm}{Summary measure used in network meta-analyses.}
\item{level.ma}{Level for confidence intervals.}
\item{reference.group, baseline.reference}{As defined above.}
}
\description{
This function can be used to combine network meta-analysis objects
which is especially useful to generate a forest plot with results
of several network meta-analyses.
}
\examples{
data(Linde2016)

# Only consider studies including Face-to-face PST (to reduce
# runtime of example)
#
face <- subset(Linde2016, id \%in\% c(16, 24, 49, 118))

# Standard random effects NMA model (with placebo as reference
# treatment)
#
net1 <- netmeta(lnOR, selnOR, treat1, treat2, id,
  data = face, reference.group = "placebo",
  sm = "OR", common = FALSE)

# Additive CNMA model with placebo as inactive component and
# reference
#
nc1 <- netcomb(net1, inactive = "placebo")

# Combine results of standard NMA and CNMA
#
nb1 <- netbind(nc1, net1,
  name = c("Additive CNMA", "Standard NMA"),
  col.study = c("red", "black"), col.square = c("red", "black"))
forest(nb1,
  col.by = "black", addrow.subgroups = FALSE,
  fontsize = 10, spacing = 0.7, squaresize = 0.9,
  label.left = "Favours Placebo",
  label.right = "Favours other")

}
\seealso{
\code{\link{netmeta}}, \code{\link{netcomb}},
  \code{\link{discomb}}, \code{\link{forest.netbind}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
