% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.netcomb.R
\name{summary.netcomb}
\alias{summary.netcomb}
\title{Summary method for objects of class netcomb}
\usage{
\method{summary}{netcomb}(
  object,
  common = object$common,
  random = object$random,
  warn.deprecated = gs("warn.deprecated"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{netcomb}.}

\item{common}{A logical indicating whether results for the common
effects model should be printed.}

\item{random}{A logical indicating whether results for the random
effects model should be printed.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{\dots}{Additional arguments (to catch deprecated arguments).}
}
\value{
A list is returned with the same elements as a
\code{\link{netcomb}} object.
}
\description{
Summary method for objects of class \code{netcomb}.
}
\examples{
data(Linde2016)

# Only consider studies including Face-to-face PST (to reduce
# runtime of example)
#
face <- subset(Linde2016, id \%in\% c(16, 24, 49, 118))

# Conduct random effects network meta-analysis
#
net1 <- netmeta(lnOR, selnOR, treat1, treat2, id,
  data = face, reference.group = "placebo",
  sm = "OR", common = FALSE)

# Additive model for treatment components
#
nc1 <- netcomb(net1)
summary(nc1)
print(summary(nc1), digits = 2, digits.stat = 3)

\dontrun{
# Conduct random effects network meta-analysis
#
net2 <- netmeta(lnOR, selnOR, treat1, treat2, id,
  data = Linde2016, reference.group = "placebo",
  sm = "OR", common = FALSE)

# Additive model for treatment components
#
nc2 <- netcomb(net2)
summary(nc2)
print(summary(nc2), digits = 2, digits.stat = 3)
}

}
\seealso{
\code{\link{netcomb}}, \code{\link{discomb}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{print}
