% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nettable.R
\name{nettable}
\alias{nettable}
\alias{print.nettable}
\title{Table with network meta-analysis results}
\usage{
nettable(
  ...,
  name = NULL,
  method = NULL,
  order = NULL,
  common,
  random,
  upper = TRUE,
  reference.group = NULL,
  baseline.reference = NULL,
  backtransf = NULL,
  nchar.trts = if (writexl) 666 else NULL,
  digits = gs("digits"),
  digits.I2 = gs("digits.I2"),
  digits.pval = gs("digits.pval"),
  scientific.pval = gs("scientific.pval"),
  zero.pval = gs("zero.pval"),
  JAMA.pval = gs("JAMA.pval"),
  big.mark = gs("big.mark"),
  text.NA = ".",
  bracket = gs("CIbracket"),
  separator = gs("CIseparator"),
  lower.blank = gs("CIlower.blank"),
  upper.blank = gs("CIupper.blank"),
  tol.direct = 5e-04,
  writexl = !missing(path),
  path = "nettable.xlsx",
  overwrite = FALSE,
  warn = FALSE,
  verbose = FALSE
)

\method{print}{nettable}(x, common = x$x$common, random = x$x$random, legend = gs("legend"), ...)
}
\arguments{
\item{\dots}{Any number of network meta-analysis objects or a
single list with network meta-analyses.}

\item{name}{An optional character vector providing descriptive
names for network meta-analysis objects.}

\item{method}{A character string indicating which method to split
direct and indirect evidence is to be used. Either
\code{"Back-calculation"} or \code{"SIDDE"}, can be abbreviated.
See Details.}

\item{order}{A optional character or numerical vector specifying
the order of treatments in comparisons.}

\item{common}{A logical indicating whether table for the common
effects network meta-analysis should be printed.}

\item{random}{A logical indicating whether table for the random
effects network meta-analysis should be printed.}

\item{upper}{A logical indicating whether treatment comparisons
should be selected from the lower or upper triangle of the
treatment effect matrices (see list elements \code{TE.common} and
\code{TE.random} in the \code{netmeta} object). Ignored if
argument \code{order} is provided.}

\item{reference.group}{Reference treatment. Ignored if argument
\code{order} is provided.}

\item{baseline.reference}{A logical indicating whether results
should be expressed as comparisons of other treatments versus the
reference treatment or vice versa. This argument is only
considered if \code{reference.group} is not equal to \code{""}
and argument\code{order} is not provided.}

\item{backtransf}{A logical indicating whether printed results
should be back transformed. For example, if \code{backtransf =
TRUE}, results for \code{sm = "OR"} are printed as odds ratios
rather than log odds ratios.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.I2}{Minimal number of significant digits for I-squared
statistic, see \code{print.default}.}

\item{digits.pval}{Minimal number of significant digits for p-value
of test of agreement between direct and indirect evidence, see
\code{print.default}.}

\item{scientific.pval}{A logical specifying whether p-values should
be printed in scientific notation, e.g., 1.2345e-01 instead of
0.12345.}

\item{zero.pval}{A logical specifying whether p-values should be
printed with a leading zero.}

\item{JAMA.pval}{A logical specifying whether p-values for test of
overall effect should be printed according to JAMA reporting
standards.}

\item{big.mark}{A character used as thousands separator.}

\item{text.NA}{A character string specifying text printed for
missing values.}

\item{bracket}{A character with bracket symbol to print lower
confidence interval: "[", "(", "\{", "".}

\item{separator}{A character string with information on separator
between lower and upper confidence interval.}

\item{lower.blank}{A logical indicating whether blanks between left
bracket and lower confidence limit should be printed.}

\item{upper.blank}{A logical indicating whether blanks between
separator and upper confidence limit should be printed.}

\item{tol.direct}{A numeric defining the maximum deviation of the
direct evidence proportion from 0 or 1 to classify a comparison
as providing only indirect or direct evidence, respectively.}

\item{writexl}{A logical indicating whether an Excel file should be
created (R package \bold{writexl} must be available).}

\item{path}{A character string specifying the filename of the Excel
file.}

\item{overwrite}{A logical indicating whether an existing Excel
file should be overwritten.}

\item{warn}{A logical indicating whether warnings should be
printed.}

\item{verbose}{A logical indicating whether progress information
should be printed.}

\item{x}{An object of class \code{nettable}.}

\item{legend}{A logical indicating whether a legend should be
printed for abbreviated treatment names.}
}
\value{
An object of class \code{nettable} with corresponding \code{print}
function if argument \code{writexl = FALSE}. The object is a list
containing the network tables in list elements 'common' and
'random'. An Excel file is created if \code{writexl = TRUE}. In
this case, \code{NULL} is returned in R.
}
\description{
Construct a table with network, direct and indirect estimates from
one or more network meta-analyses.
}
\details{
Construct a table with network, direct and indirect estimates from
one or more network meta-analyses. The table looks very similar to
the statistical part of a GRADE table for a network meta-analysis
(Puhan et al., 2014).

By default, an R object with the network tables is
generated. Alternatively, an Excel file is created if argument
\code{writexl = TRUE}.

Two methods to derive indirect estimates are available:
\itemize{
\item Separate Indirect from Direct Evidence (SIDE) using a
  back-calculation method (\code{method = "Back-calculation"})
  based on the \emph{direct evidence proportion} to calculate the
  indirect evidence (König et al., 2013);
\item Separate Indirect from Direct Design Evidence (SIDDE) as
  described in Efthimiou et al. (2019).
}

Note, for the back-calculation method, indirect treatment estimates
are already calculated in \code{\link{netmeta}} and this function
combines and prints these estimates in a user-friendly
way. Furthermore, this method is not available for the
Mantel-Haenszel and non-central hypergeometric distribution
approach implemented in \code{\link{netmetabin}}.

For the random-effects model, the direct treatment estimates are
based on the common between-study variance \eqn{\tau^2} from the
network meta-analysis, i.e. the square of list element
\code{x$tau}.

The SIDDE approach can be compute-intensive in large
networks. Crude information on the computation progress is printed
for SIDDE if argument \code{verbose} is \code{TRUE}.
}
\examples{
p1 <- pairwise(treatment, event = r, n = N,
  studlab = author, data = dat.woods2010, sm = "OR")
#
net1 <- netmeta(p1)
#
nt1 <- nettable(net1, digits = 2)
nt1
print(nt1, common = FALSE)
print(nt1, random = FALSE)

\dontrun{
# Create a CSV file with network table from random effects model
#
table1 <- nettable(net1, digits = 2, bracket = "(", separator = " to ")
#
write.table(table1$random, file = "table1-random.csv",
  row.names = FALSE, col.names = TRUE, sep = ",")
#
# Create Excel files with network tables
# (if R package writexl is available)
#
if (requireNamespace("writexl", quietly = TRUE))
  nettable(net1, digits = 2, bracket = "(", separator = " to ",
           path = tempfile(fileext = ".xlsx"))
}

}
\references{
Dias S, Welton NJ, Caldwell DM, Ades AE (2010):
Checking consistency in mixed treatment comparison meta-analysis.
\emph{Statistics in Medicine},
\bold{29}, 932--44

Efthimiou O, Rücker G, Schwarzer G, Higgins J, Egger M, Salanti G
(2019):
A Mantel-Haenszel model for network meta-analysis of rare events.
\emph{Statistics in Medicine},
\bold{38}, 2992--3012

König J, Krahn U, Binder H (2013):
Visualizing the flow of evidence in network meta-analysis and
characterizing mixed treatment comparisons.
\emph{Statistics in Medicine},
\bold{32}, 5414--29

Puhan MA, Schünemann HJ, Murad MH, et al. (2014):
A GRADE working group approach for rating the quality of treatment
effect estimates from network meta-analysis.
\emph{British Medical Journal},
\bold{349}, g5630
}
\seealso{
\code{\link{netsplit}}, \code{\link{netmeta}},
  \code{\link{netmetabin}}, \code{\link{netmeasures}},
  \code{\link[metadat]{dat.woods2010}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
