% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netmetabin.R
\name{netmetabin}
\alias{netmetabin}
\title{Network meta-analysis of binary outcome data}
\usage{
netmetabin(
  event1,
  n1,
  event2,
  n2,
  treat1,
  treat2,
  studlab,
  data = NULL,
  subset = NULL,
  sm,
  method = "MH",
  cc.pooled = FALSE,
  incr,
  method.incr,
  allstudies,
  level = gs("level"),
  level.ma = gs("level.ma"),
  common = gs("common"),
  random = method \%in\% c("Inverse", "LRP") & (gs("random") | !is.null(tau.preset)),
  prediction = gs("prediction"),
  level.predict = gs("level.predict"),
  reference.group,
  baseline.reference = gs("baseline.reference"),
  small.values = gs("small.values"),
  all.treatments = gs("all.treatments"),
  seq = gs("seq"),
  tau.preset = NULL,
  tol.multiarm = 0.001,
  tol.multiarm.se = NULL,
  details.chkmultiarm = FALSE,
  details.chkdata = TRUE,
  sep.trts = ":",
  nchar.trts = 666,
  func.inverse = invmat,
  overall.hetstat = gs("overall.hetstat"),
  backtransf = gs("backtransf"),
  title = gs("title"),
  keepdata = gs("keepdata"),
  addincr,
  allincr,
  warn = gs("warn"),
  warn.deprecated = gs("warn.deprecated"),
  ...
)
}
\arguments{
\item{event1}{Number of events (first treatment).}

\item{n1}{Number of observations (first treatment).}

\item{event2}{Number of events (second treatment).}

\item{n2}{Number of observations (second treatment)}

\item{treat1}{Label/Number for first treatment.}

\item{treat2}{Label/Number for second treatment.}

\item{studlab}{An optional - but important! - vector with study
labels (see Details).}

\item{data}{An optional data frame containing the study
information.}

\item{subset}{An optional vector specifying a subset of studies to
be used.}

\item{sm}{A character string indicating underlying summary measure,
i.e., \code{"RD"}, \code{"RR"}, \code{"OR"}, \code{"ASD"}.}

\item{method}{A character string indicating which method is to be
used for pooling of studies. One of \code{"MH"},
\code{"NCH"}, \code{"LRP"}, or \code{"Inverse"}, can be abbreviated.}

\item{cc.pooled}{A logical indicating whether \code{incr} should be
used as a continuity correction, when calculating the network
meta-analysis estimates (ignored for penalised logistic regression and
inverse variance method).}

\item{incr}{A numerical value which is added to each cell count,
i.e., to the numbers of events and non-events, of all treatment
arms in studies with zero events or non-events in any of the
treatment arms ("continuity correction").}

\item{method.incr}{A character string indicating which continuity
correction method should be used (\code{"only0"},
\code{"if0all"}, or \code{"all"}), see \code{\link[meta]{metabin}}.}

\item{allstudies}{A logical indicating whether studies with zero
events or non-events in all treatment arms should be included in
an inverse variance meta-analysis (applies only if \code{method =
"Inverse"} and \code{sm} is equal to either \code{"RR"} or
\code{"OR"}).}

\item{level}{The level used to calculate confidence intervals for
individual studies.}

\item{level.ma}{The level used to calculate confidence intervals
for network estimates.}

\item{common}{A logical indicating whether a common effects network
meta-analysis should be conducted.}

\item{random}{A logical indicating whether a random effects network
meta-analysis should be conducted.}

\item{prediction}{A logical indicating whether a prediction
interval should be printed (only considered if \code{method =
"Inverse"}).}

\item{level.predict}{The level used to calculate prediction
interval for a new study (only considered if \code{method =
"Inverse"}).}

\item{reference.group}{Reference treatment.}

\item{baseline.reference}{A logical indicating whether results
should be expressed as comparisons of other treatments versus the
reference treatment (default) or vice versa. This argument is
only considered if \code{reference.group} has been specified.}

\item{small.values}{A character string specifying whether small
treatment effects indicate a beneficial (\code{"desirable"}) or
harmful (\code{"undesirable"}) effect (passed on to
\code{\link{netrank}}, can be abbreviated.}

\item{all.treatments}{A logical or \code{"NULL"}. If \code{TRUE},
matrices with all treatment effects, and confidence limits will
be printed.}

\item{seq}{A character or numerical vector specifying the sequence
of treatments in printouts.}

\item{tau.preset}{An optional value for manually setting the
square-root of the between-study variance \eqn{\tau^2} (only
considered if \code{method = "Inverse"}).}

\item{tol.multiarm}{A numeric for the tolerance for consistency of
treatment estimates in multi-arm studies which are consistent by
design (only considered if \code{method = "Inverse"}).}

\item{tol.multiarm.se}{A numeric for the tolerance for consistency
of standard errors in multi-arm studies which are consistent by
design (only considered if the argument is not \code{NULL} and
\code{method = "Inverse"}).}

\item{details.chkmultiarm}{A logical indicating whether treatment
estimates and / or variances of multi-arm studies with
inconsistent results or negative multi-arm variances should be
printed (only considered if \code{method = "Inverse"}).}

\item{details.chkdata}{A logical indicating whether number of
events and participants of studies with inconsistent data should
be printed.}

\item{sep.trts}{A character used in comparison names as separator
between treatment labels.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names (see Details).}

\item{func.inverse}{R function used to calculate the pseudoinverse
of the Laplacian matrix L (see \code{\link{netmeta}}).}

\item{overall.hetstat}{A logical indicating whether to print heterogeneity
measures.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and forest plots. If
\code{backtransf = TRUE}, results for \code{sm = "OR"} are
presented as odds ratios rather than log odds ratios, for
example.}

\item{title}{Title of meta-analysis / systematic review.}

\item{keepdata}{A logical indicating whether original data(set)
should be kept in netmeta object.}

\item{addincr}{Deprecated argument (replaced by 'method.incr');
see \code{\link[meta]{metabin}}.}

\item{allincr}{Deprecated argument (replaced by 'method.incr');
see \code{\link[meta]{metabin}}.}

\item{warn}{A logical indicating whether warnings should be printed
(e.g., if studies are excluded from meta-analysis due to zero
standard errors).}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{\dots}{Additional arguments (to catch deprecated arguments).}
}
\value{
An object of class \code{netmetabin} and \code{netmeta} with
corresponding \code{print}, \code{summary}, \code{forest}, and
\code{netrank} functions. The object is a list containing the
following components:
\item{studlab, treat1, treat2}{As defined above.}
\item{n1, n2, event1, event2}{As defined above.}
\item{TE}{Estimate of treatment effect, i.e. difference between
  first and second treatment (e.g. log odds ratio).}
\item{seTE}{Standard error of treatment estimate.}
\item{k}{Total number of studies.}
\item{m}{Total number of pairwise comparisons.}
\item{n}{Total number of treatments.}
\item{d}{Total number of designs (corresponding to the unique set
  of treatments compared within studies).}
\item{trts}{Treatments included in network meta-analysis.}
\item{k.trts}{Number of studies evaluating a treatment.}
\item{n.trts}{Number of observations receiving a treatment.}
\item{events.trts}{Number of events observed for a treatment.}
\item{studies}{Study labels coerced into a factor with its levels
  sorted alphabetically.}
\item{narms}{Number of arms for each study.}
\item{designs}{Unique list of designs present in the network. A
  design corresponds to the set of treatments compared within a
  study.}
\item{TE.common, seTE.common}{\emph{n}x\emph{n} matrix with estimated
  overall treatment effects and standard errors for common effects
  model.}
\item{lower.common, upper.common}{\emph{n}x\emph{n} matrices with
  lower and upper confidence interval limits for common effects
  model.}
\item{statistic.common, pval.common}{\emph{n}x\emph{n} matrices with
  z-value and p-value for test of overall treatment effect under
  common effects model.}
\item{TE.random, seTE.random}{\emph{n}x\emph{n} matrix with
  estimated overall treatment effects and standard errors for
  random effects model (only available if \code{method =
  "Inverse"}).}
\item{lower.random, upper.random}{\emph{n}x\emph{n} matrices with
  lower and upper confidence interval limits for random effects
  model (only available if \code{method = "Inverse"}).}
\item{statistic.random, pval.random}{\emph{n}x\emph{n} matrices
  with z-value and p-value for test of overall treatment effect
  under random effects model (only available if \code{method =
  "Inverse"}).}
\item{TE.direct.common, seTE.direct.common}{\emph{n}x\emph{n} matrix
  with estimated treatment effects and standard errors from direct
  evidence under common effects model.}
\item{lower.direct.common, upper.direct.common}{\emph{n}x\emph{n}
  matrices with lower and upper confidence interval limits from
  direct evidence under common effects model.}
\item{statistic.direct.common, pval.direct.common}{\emph{n}x\emph{n}
  matrices with z-value and p-value for test of overall treatment
  effect from direct evidence under common effects model.}
\item{TE.direct.random, seTE.direct.random}{\emph{n}x\emph{n}
  matrix with estimated treatment effects and standard errors from
  direct evidence under random effects model (only available if
  \code{method = "Inverse"}).}
\item{lower.direct.random, upper.direct.random}{\emph{n}x\emph{n}
  matrices with lower and upper confidence interval limits from
  direct evidence under random effects model (only available if
  \code{method = "Inverse"}).}
\item{statistic.direct.random,
  pval.direct.random}{\emph{n}x\emph{n} matrices with z-value and
  p-value for test of overall treatment effect from direct evidence
  under random effects model (only available if \code{method =
  "Inverse"}).}
\item{Q}{Overall heterogeneity / inconsistency statistic. (only
  available if \code{method = "Inverse"})}
\item{df.Q}{Degrees of freedom for test of heterogeneity /
  inconsistency.}
\item{pval.Q}{P-value for test of heterogeneity / inconsistency.}
\item{I2, lower.I2, upper.I2}{I-squared, lower and upper confidence
  limits (only available if \code{method = "Inverse"}).}
\item{tau}{Square-root of between-study variance (only available if
  \code{method = "Inverse"}).}
\item{Q.heterogeneity}{Overall heterogeneity statistic. (only
  available if \code{method = "Inverse"})}
\item{df.Q.heterogeneity}{Degrees of freedom for test of overall
  heterogeneity.}
\item{pval.Q.heterogeneity}{P-value for test of overall
  heterogeneity.}
\item{Q.inconsistency}{Overall inconsistency statistic.}
\item{df.Q.inconsistency}{Degrees of freedom for test of overall
  inconsistency.}
\item{pval.Q.inconsistency}{P-value for test of overall
  inconsistency.}
\item{A.matrix}{Adjacency matrix (\emph{n}x\emph{n}).}
\item{H.matrix.common}{Hat matrix (\emph{m}x\emph{m})}
\item{n.matrix}{\emph{n}x\emph{n} matrix with number of
  observations in direct comparisons.}
\item{events.matrix}{\emph{n}x\emph{n} matrix with number of events
  in direct comparisons.}
\item{sm, method, level, level.ma}{As defined above.}
\item{incr, method.incr, allstudies, cc.pooled}{As defined
  above.}
\item{addincr, allincr}{As defined above.}
\item{common, random}{As defined above.}
\item{prediction, level.predict}{As defined above.}
\item{reference.group, baseline.reference, small.values, all.treatments}{As
  defined above.}
\item{seq, tau.preset, tol.multiarm, tol.multiarm.se}{As defined
  above.}
\item{details.chkmultiarm, details.chkdata}{As defined above.}
\item{sep.trts, nchar.trts, overall.hetstat}{As defined above.}
\item{backtransf, title, warn, warn.deprecated}{As defined above.}
\item{data}{Dataset (in contrast-based format).}
\item{data.design}{List with data in arm-based format (each list
  element corresponds to a single design).}
\item{call}{Function call.}
\item{version}{Version of R package netmeta used to create object.}
}
\description{
Provides four models for the network meta-analysis of binary data
(Mantel-Haenszel method, based on the non-central hypergeometric
distribution, penalised logistic regression, and the
inverse variance method).
}
\details{
This function implements four models for the network meta-analysis
of binary data:
\itemize{
\item The Mantel-Haenszel network meta-analysis model, as described
  in Efthimiou et al. (2019) (\code{method = "MH"});
\item a network meta-analysis model using the non-central
  hypergeometric distribution with the Breslow approximation, as
  described in Stijnen et al. (2010) (\code{method = "NCH"});
\item a logistic regression with penalised likelihood, as described
  in Evrenoglou et al. (2022) (\code{method = "LRP"});
\item the inverse variance method for network meta-analysis
  (\code{method = "Inverse"}), also provided by
  \code{\link{netmeta}}.
}

Comparisons belonging to multi-arm studies are identified by
identical study labels (argument \code{studlab}). It is therefore
important to use identical study labels for all comparisons
belonging to the same multi-arm study.

Data entry for this function is in \emph{contrast-based} format,
that is, each line of the data corresponds to a single pairwise
comparison between two treatments (arguments \code{treat1},
\code{treat2}, \code{event1}, \code{n1}, \code{event2}, and
\code{n2}). If data are provided in \emph{arm-based} format, that
is, number of events and participants are given for each treatment
arm separately, function \code{\link[meta]{pairwise}} can be used to
transform the data to \emph{contrast-based} format (see help page
of function \code{\link[meta]{pairwise}}).

Note, all pairwise comparisons must be provided for a multi-arm
study. Consider a multi-arm study of \emph{p} treatments with known
variances. For this study, the number of events and observations
must be provided for each treatment, for each of \emph{p}(\emph{p}
- 1) / 2 possible comparisons in separate lines in the data. For
instance, a three-arm study contributes three pairwise comparisons,
a four-arm study even six pairwise comparisons. Function
\code{\link[meta]{pairwise}} automatically calculates all pairwise
comparisons for multi-arm studies.

For \code{method = "Inverse"}, both common and random effects
models are calculated regardless of values chosen for arguments
\code{common} and \code{random}. Accordingly, the network estimates
for the random effects model can be extracted from component
\code{TE.random} of an object of class \code{"netmeta"} even if
argument \code{random = FALSE}.  However, all functions in R
package \bold{netmeta} will adequately consider the values for
\code{common} and \code{random}. E.g. function
\code{\link{print.summary.netmeta}} will not print results for the
random effects model if \code{random = FALSE}.

For the random-effects model, the direct treatment estimates are
based on the common between-study variance \eqn{\tau^2} from the
network meta-analysis.

For \code{method = "MH"} and \code{method = "NCH"}, only a common
effects model is available.

By default, treatment names are not abbreviated in
printouts. However, in order to get more concise printouts,
argument \code{nchar.trts} can be used to define the minimum number
of characters for abbreviated treatment names (see
\code{\link{abbreviate}}, argument \code{minlength}). R function
\code{\link{treats}} is utilised internally to create abbreviated
treatment names.

Names of treatment comparisons are created by concatenating
treatment labels of pairwise comparisons using \code{sep.trts} as
separator (see \code{\link{paste}}). These comparison names are
used in the covariance matrices \code{Cov.common} and
\code{Cov.random} and in some R functions, e.g,
\code{\link{decomp.design}}. By default, a colon is used as the
separator. If any treatment label contains a colon the following
characters are used as separator (in consecutive order):
\code{"-"}, \code{"_"}, \code{"/"}, \code{"+"}, \code{"."},
\code{"|"}, and \code{"*"}. If all of these characters are used in
treatment labels, a corresponding error message is printed asking
the user to specify a different separator.
}
\examples{
# Only consider first four studies (to reduce runtime of example)
#
first4 <- subset(dat.dong2013, id <= 4)

# Transform data from long arm-based format to contrast-based
# format. Argument 'sm' has to be used for odds ratio as summary
# measure; by default the risk ratio is used in the metabin
# function called internally.
#
pw1 <- pairwise(treatment, death, randomized, studlab = id,
  data = first4, sm = "OR")

# Conduct Mantel-Haenszel network meta-analysis (without continuity
# correction)
#
nb1 <- netmetabin(pw1, ref = "plac")
nb1

# Obtain the league table
#
netleague(nb1)

\donttest{
# Conduct Mantel-Haenszel network meta-analysis for the whole
# dataset
#
pw2 <- pairwise(treatment, death, randomized, studlab = id,
  data = dat.dong2013, sm = "OR")
netmetabin(pw2, ref = "plac")
  
# Conduct network meta-analysis using the non-central
# hypergeometric model (without continuity correction)
#
netmetabin(pw2, ref = "plac", method = "NCH")

# Conduct Mantel-Haenszel network meta-analysis (with continuity
# correction of 0.5; include all studies)
#
netmetabin(pw2, ref = "plac", cc.pooled = TRUE)

pw3 <- pairwise(treatment, death, n, studlab = study,
  data = dat.gurusamy2011, sm = "OR")

# Conduct Mantel-Haenszel network meta-analysis (without continuity
# correction)
#
netmetabin(pw3, ref = "cont")
}

}
\references{
Efthimiou O, Rücker G, Schwarzer G, Higgins J, Egger M, Salanti G
(2019):
A Mantel-Haenszel model for network meta-analysis of rare events.
\emph{Statistics in Medicine},
\bold{38}, 2992--3012

Evrenoglou T, White IR, Afach S, Mavridis D, Chaimani A (2022):
Network Meta-Analysis of Rare Events Using Penalized Likelihood Regression.
\emph{Statistics in Medicine},
\bold{41}, 5203--19.

Senn S, Gavini F, Magrez D, Scheen A (2013):
Issues in performing a network meta-analysis.
\emph{Statistical Methods in Medical Research},
\bold{22}, 169--89

Stijnen T, Hamza TH, Ozdemir P (2010):
Random effects meta-analysis of event outcome in the framework of
the generalized linear mixed model with applications in sparse
data.
\emph{Statistics in Medicine},
\bold{29}, 3046--67
}
\seealso{
\code{\link[meta]{pairwise}}, \code{\link{netmeta}},
  \code{\link[metadat]{dat.gurusamy2011}},
  \code{\link[metadat]{dat.dong2013}}
}
\author{
Orestis Efthimiou \email{oremiou@gmail.com}, Guido
  Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de},
  Theodoros Evrenoglou \email{theodoros.evrenoglou@uniklinik-freiburg.de}
}
