% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piechart.R
\name{piechart}
\alias{piechart}
\title{A flexible piechart.}
\usage{
piechart(
  x,
  labels = names(x),
  radius = 1,
  doughnut = 0,
  origin = c(0, 0),
  edges = 200,
  slice.off = 0,
  init.angle = 0,
  last.angle = 360,
  tick.len = 0.1,
  text.args = list(),
  segments.args = list(),
  skip.plot.slices = FALSE,
  add = FALSE,
  rescale = TRUE,
  ...
)
}
\arguments{
\item{x}{Numeric vector. Values that specify the area of the slices.}

\item{labels}{Character vector of length \code{length(x)}. Passed to
\code{\link[graphics:text]{graphics::text()}}.}

\item{radius}{Numeric vector. Radious of each slice (can be a scalar).}

\item{doughnut}{Numeric scalar. Radious of each inner circle (doughnut) (can be a scalar).}

\item{origin}{Numeric vector of length 2. Coordinates of the origin.}

\item{edges}{Numeric scalar. Smoothness of the slices curve (can be a vector).}

\item{slice.off}{Numeric vector. When \verb{!=0}, specifies how much to
move the slice away from the origin. When scalar is recycled.}

\item{init.angle}{Numeric scalar. Angle from where to start drawing in degrees.}

\item{last.angle}{Numeric scalar. Angle where to finish drawing in degrees.}

\item{tick.len}{Numeric scalar. Size of the tick marks as proportion of the radius.}

\item{text.args}{List. Further arguments passed to \code{\link[graphics:text]{graphics::text()}}.}

\item{segments.args}{List. Further arguments passed to \code{\link[graphics:segments]{graphics::segments()}}
when drawing the tickmarks.}

\item{skip.plot.slices}{Logical scalar. When \code{FALSE}, slices are not drawn.
This can be useful if, for example, the user only wants to draw the labels.}

\item{add}{Logical scalar. When \code{TRUE} it is added to the current device.}

\item{rescale}{Logical scalar. When \code{TRUE} (default), the y-coordinates of
the polygons (slices), text and tickmarks will be rescaled such that the
aspectt ratio is preserved, i.e. looks like a circle.}

\item{...}{Further arguments passed to \code{\link[graphics:polygon]{graphics::polygon()}}
(see details).}
}
\value{
A list with the following elements:
\item{slices}{A list of length \code{length(x)} with the coordinates of each
slice.}
\item{textcoords}{A numeric matrix of size \code{length(x)*2} with
coordinates where the labels can be put at.}
\item{alpha0}{A numeric vector of size \code{length(x)} with the starting
degree in radians of the slice.}
\item{alpha1}{A numeric vector of size \code{length(x)} with the ending
degree in radians of the slice.}
}
\description{
While similar to \code{\link[graphics:pie]{graphics::pie()}}, this function is much more
flexible as it allows providing different parameters for each slice of the pie.
Furthermore, it allows adding the plot to the current device, making it possible
to create compound piecharts.
}
\details{
The function is a wrapper of \code{\link[graphics:polygon]{graphics::polygon()}},
so all parameters such as color, density, border, etc. are passed directly
by \code{\link[=mapply]{mapply()}} so that are specified one per slice. The coordinates
of the slices are computed internally.
}
\examples{

# Example 1 -----------------------------------------------------------------
# A set of 3 nested rings rings starting at 315 deg. and ending at 270 deg.

# Values to plot
vals <- c(1,2,3,10)

# Outer (includes labels)
piechart(vals, col=grDevices::blues9[5:8], border=NA, doughnut = .5,
    radius=.75, labels=vals, init.angle = 315, last.angle = 270)

# Middle
piechart(vals, col=grDevices::blues9[3:6], border=NA, doughnut = .3,
    radius=.5, add=TRUE, init.angle = 315, last.angle = 270)

# Inner
piechart(vals, col=grDevices::blues9[1:4], border="gray", doughnut = .1,
    radius=.3, add=TRUE, init.angle = 315, last.angle = 270)

# Example 2 -----------------------------------------------------------------
# Passing values to polygon and playing with the radius and slice.off

piechart(1:10, density=(1:10)^2/2, slice.off = (1:10)/30, doughnut = .5,
  radius = sqrt(10:1),
  # Here we are setting random labels...
  labels=sapply(1:10, function(x) paste(sample(letters, x, TRUE), collapse=""))
  )

}
\seealso{
https://commons.wikimedia.org/wiki/File:Nightingale-mortality.jpg
}
