% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transitive.reduction.R
\name{transitive_reduction}
\alias{transitive_reduction}
\title{Transitive Reduction}
\usage{
transitive_reduction(P)
}
\arguments{
\item{P}{A partial ranking as matrix object calculated with \link{neighborhood_inclusion}
or \link{positional_dominance}.}
}
\value{
transitive reduction of \code{P}
}
\description{
Calculates the transitive reduction of a partial ranking.
}
\examples{
library(igraph)

g <- threshold_graph(100, 0.1)
P <- neighborhood_inclusion(g)
sum(P)

R <- transitive_reduction(P)
sum(R)
}
\author{
David Schoch
}
