% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjacency.R
\name{adjacency}
\alias{adjacency}
\title{Create adjacency matrix}
\usage{
adjacency(from, to, weight = 1, directed = TRUE)
}
\arguments{
\item{from}{a vector of nodes where the edges originate}

\item{to}{a vector of nodes where the edges point to}

\item{weight}{a numeric vector of weights}

\item{directed}{logical. Are the edges directed (TRUE, the default) or bidirected(FALSE).}
}
\value{
Returns a sparse adjacency matrix
}
\description{
Create an adjacency matrix from a set of nodes and edges.
}
\examples{

from <- c("A", "A", "A", "B", "C")
to <- c("B", "C", "D", "D", "E")
adjacency(from, to)

from <- c("A", "A", "A", "B", "C")
to <- c("B", "C", "D", "D", "E")
weights <- c(1, .5, 1, .7, 1)
adjacency(from, to, weights)

}
\author{
Claus Ekstrom \email{ekstrom@sund.ku.dk}
}
\keyword{manip}
