% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/known_population.r
\name{kp.individual.estimator}
\alias{kp.individual.estimator}
\alias{kp.individual.estimator_}
\title{Individual personal network size estimates using the known population method}
\usage{
kp.individual.estimator(resp.data, known.populations, total.kp.size = 1,
  alter.popn.size)

kp.individual.estimator_(resp.data, known.populations, total.kp.size = 1,
  alter.popn.size)
}
\arguments{
\item{resp.data}{the respondent (survey) data}

\item{known.populations}{the names of the known populations}

\item{total.kp.size}{the sum of the sizes of all of the known populations}

\item{alter.popn.size}{the size of the population respondents
are reporting about connections to; typically this will
be the frame population, so \code{alter.popn.size} should
be the size of the frame population, N.F}
}
\value{
a data frame with an estimate of each individual respondent's personal
        network size
}
\description{
In most situations, the known population method will be
used to estimate the average personal network size;
this can be done with \code{\link{kp.estimator_}}. If, instead, you wish
to estimate the personal network size of each individual
respondent, then you can use this function.
}
\details{
Note that this is not making inference about any larger population;
it estimates a property of each individual respondent. So the
sampling weights are not used here.
}
\section{TODO}{

\itemize{
\item{ handle missing values! }
\item{ make unit tests }
}
}

