% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_print_plot.R
\name{plot.global.impact}
\alias{plot.global.impact}
\title{Plot "global.impact" objects}
\usage{
\method{plot}{global.impact}(x, order = c("alphabetical", "value"),
  zscore = FALSE, abs_val = FALSE, ...)
}
\arguments{
\item{x}{an output object from an impact function (class \code{global.impact})}

\item{order}{"alphabetical" orders nodes alphabetically, "value" orders nodes from
highest to lowest impact value}

\item{zscore}{logical. Converts raw impact statistics to z-scores for plotting}

\item{abs_val}{logical. Plot absolute values of global strength impacts}

\item{...}{other plotting specifications (ggplot2)}
}
\description{
Convenience function for generating global strength impact plots
}
\details{
Inputting an object of class \code{global.impact}
will return a line plot that shows the relative global impacts of each node.
}
\examples{
out <- global.impact(depression[,1:5])
plot(out)
\donttest{
out1 <- global.impact(depression)
plot(out1)
plot(out1, order="value", zscore=TRUE)
out2 <- impact(depression)
plot(out2$Global.Strength)
}
}
