% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_aws_url.R
\name{hcp_aws_url}
\alias{hcp_aws_url}
\title{Construct AWS S3 String}
\usage{
hcp_aws_url(path_to_file = "", bucket = "hcp-openaccess",
  region = "us-east-1", access_key = NULL, secret_key = NULL,
  lifetime_minutes = 20, query = NULL, verb = "GET", sign = TRUE)
}
\arguments{
\item{path_to_file}{Path to file on HCP S3 Bucket}

\item{bucket}{Bucket to download from}

\item{region}{Region of S3 Bucket}

\item{access_key}{Amazon S3 Access Key}

\item{secret_key}{Amazon S3 Secret Key}

\item{lifetime_minutes}{Time that connection can be opened}

\item{query}{additional query to add to url}

\item{verb}{httr VERB to be used}

\item{sign}{Should the url be signed?}
}
\value{
Character of the url to be passed to \code{httr} VERBs
}
\description{
Constructs url string for AWS S3 Bucket to pass in for HCP
downloading
}
\examples{
\dontrun{
path_to_file <- "HCP_900/100206/MNINonLinear/100206.164k_fs_LR.wb.spec"
hcp_aws_url(path_to_file)
}
}
