% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/button.R
\name{actionButton}
\alias{actionButton}
\title{Create a button}
\usage{
actionButton(
  inputId,
  label,
  icon = NULL,
  width = NULL,
  ...,
  size = c("m", "xs", "s", "l", "xl"),
  style = c("default", "pill", "round", "clean"),
  bg.type = c("default", "primary", "secondary", "info", "success", "danger",
    "warning"),
  outline = FALSE
)
}
\arguments{
\item{inputId}{Input identification}

\item{label}{Input label}

\item{icon}{Choice of button icon}

\item{width}{Width of the bottom}

\item{...}{other elements or attributes for the button}

\item{size}{Size of the button, choices include "m","xs", "s", "l", "xl"}

\item{style}{Style of the button, choices include "default", "pill", "round", "clean"}

\item{bg.type}{Color of the button, choices include "default", "primary", "secondary", "info", "success", "danger", "warning"}

\item{outline}{Use an outline styling, TRUE or FALSE}
}
\value{
HTML of the buttons to insert into a page
}
\description{
Upgrade to the actionButton in 'Shiny' package
}
\examples{
if (interactive()) {
shiny::div(actionButton("button",
  "Action button with primary color",
  icon = shiny::icon("folder"), bg.type = "primary"
))
shiny::div(actionButton("button",
  "Action button with primary color",
  icon = shiny::icon("file"),
  bg.type = "danger", outline = TRUE
))
}

}
