% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabs.R
\name{tabsetPanel}
\alias{tabsetPanel}
\title{Create an advanced tabset}
\usage{
tabsetPanel(
  ...,
  type = c("default", "pills", "clean", "jPills", "justified"),
  border = TRUE,
  justified = FALSE,
  position = c("left", "end", "center")
)
}
\arguments{
\item{...}{Content of the tabset, created using the tabPanel for each individual item}

\item{type}{Type of tabset to create, choices include "default","pills","clean","jPills","justified"}

\item{border}{Include a board for the tabset, TRUE or FALSE}

\item{justified}{Justify tab headers, TRUE or FALSE}

\item{position}{position of the tabs, choices include "left","end","center"}
}
\value{
An HTML containing elements of a tabset to be embedded in a page
}
\description{
Advanced tabset panel with styles and functionalities
}
\note{
Many examples exist for the tabset, fid them using the package load.example function
}
\examples{
\donttest{
if (interactive()) {
  library(shiny)
  library(nextGenShinyApps)
  tab2 <- tabPanel("Summary", "SAMPLE nunc.")
  tab3 <- tabPanel("Tab 3", "aoreet sit amet.")
  tab4 <- tabPanel("Tab 4", "Vulputate pulvinar")


  shiny::shinyApp(
    ui = fluidPage(
      style = "8",
      custom.bg.color = "rgb(110,134,032)",
      sidebar = NULL,
      header = NULL,
      tabsetPanel(
        tab2,
        tab3,
        type = "pills",
        justified = TRUE
      )
    ),
    server = function(input, output) {
    }
  )
}
}

}
