% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{teams_colors_logos}
\alias{teams_colors_logos}
\title{NFL Team names, colors and logo urls.}
\format{
A data frame with 36 rows and 10 variables containing NFL team level
information, including franchises in multiple cities:
\describe{
\item{team_abbr}{Team abbreviation}
\item{team_name}{Complete Team name}
\item{team_id}{Team id used in the roster function}
\item{team_nick}{Nickname}
\item{team_conf}{Conference}
\item{team_division}{Division}
\item{team_color}{Primary color}
\item{team_color2}{Secondary color}
\item{team_color3}{Tertiary color}
\item{team_color4}{Quaternary color}
\item{team_logo_wikipedia}{Url to Team logo on wikipedia}
\item{team_logo_espn}{Url to higher quality logo on espn}
\item{team_wordmark}{Url to team wordmarks}
\item{team_conference_logo}{Url to AFC and NFC logos}
\item{team_league_logo}{Url to NFL logo}
}
The primary and secondary colors have been taken from nfl.com with some modifications
for better team distinction and most recent team color themes.
The tertiary and quaternary colors are taken from Lee Sharpe's teamcolors.csv
who has taken them from the \code{teamcolors} package created by Ben Baumer and
Gregory Matthews. The Wikipeadia logo urls are taken from Lee Sharpe's logos.csv
Team wordmarks from nfl.com
}
\usage{
teams_colors_logos
}
\description{
NFL Team names, colors and logo urls.
}
\examples{
\donttest{
teams_colors_logos
}
}
\keyword{datasets}
