% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse.sglmm.R
\name{summary.sparse.sglmm}
\alias{summary.sparse.sglmm}
\title{Print a summary of a sparse SGLMM fit.}
\usage{
\method{summary}{sparse.sglmm}(object, alpha = 0.05, digits = 4, ...)
}
\arguments{
\item{object}{an object of class \code{sparse.sglmm}, typically the result of a call to \code{\link{sparse.sglmm}}.}

\item{alpha}{the significance level used to compute the HPD intervals. The default is 0.05.}

\item{digits}{the number of significant digits to display. The default is 4.}

\item{\dots}{additional arguments.}
}
\description{
Print a summary of a sparse SGLMM fit.
}
\details{
This function displays (1) the call to \code{\link{sparse.sglmm}}, (2) the values of the hyperparameters and tuning parameters, (3) a table of estimates, (4) the DIC value for the fit, and (5) the number of posterior samples. Each row of the table of estimates shows an estimated regression coefficient, the HPD interval for the coefficient, and the Monte Carlo standard error.
}
\seealso{
\code{\link{sparse.sglmm}}
}

