% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_nhdplus.R
\name{get_flowline_index}
\alias{get_flowline_index}
\title{Get Flowline Index}
\usage{
get_flowline_index(flines, points, search_radius = 0.1, precision = NA)
}
\arguments{
\item{flines}{sf data.frame of type LINESTRING or MULTILINESTRING including
COMID, REACHCODE, ToMeas, and FromMeas}

\item{points}{sfc of type POINT}

\item{search_radius}{numeric the distance for the nearest neighbor search
to extend.
See RANN nn2 documentation for more details.}

\item{precision}{numeric the resolution of measure precision in the output.}
}
\value{
data.frame with four columns, COMID, REACHCODE, REACH_meas, and offset.
}
\description{
given an sf point geometry column, return COMID, reachcode,
and measure for each.
}
\details{
Note 1: Inputs are cast into LINESTRINGS. Because of this,
the measure output
of inputs that are true multipart lines may be in error.

Note 2: This algorithm finds the nearest node in the input flowlines to
identify which flowline the point should belong to. As a second pass,
it can calculate the measure to greater precision than the nearest flowline
geometry node.

Note 3: Offset is returned in units consistant with the projection of
the flowlines.
}
\examples{
sample_flines <- sf::read_sf(system.file("extdata",
                                         "petapsco_flowlines.gpkg",
                                         package = "nhdplusTools"))
get_flowline_index(sample_flines,
                   sf::st_sfc(sf::st_point(c(-76.87479,
                                             39.48233)),
                              crs = 4326))

}
