% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_nhdplus.R
\name{disambiguate_flowline_indexes}
\alias{disambiguate_flowline_indexes}
\title{Disambiguate Flowline Indexes}
\usage{
disambiguate_flowline_indexes(indexes, flowpath, hydro_location)
}
\arguments{
\item{indexes}{data.frame as output from \link{get_flowline_index} with more than
one hydrologic location per indexed point.}

\item{flowpath}{data.frame with two columns. The first should join to the COMID
field of the indexes and the second should be the numeric or ascii metric such as drainage
area or GNIS Name. Names of this data.frame are not used.}

\item{hydro_location}{data.frame with two columns. The first should join to the
id field of the indexes and the second should be the numeric or ascii metric such as drainage
area or GNIS Name.. Names of this data,frame are not used.}
}
\value{
data.frame indexes deduplicated according to the minimum difference
between the values in the metric columns. If two or more result in the same "minimum"
value, duplicates will be returned.
}
\description{
Given a set of flowline indexes and numeric or ascii criteria,
return closest match. If numeric criteria are used, the minimum difference
in the numeric attribute is used for disambiguation. If ascii criteria are used,
the \link[utils]{adist} function is used with the following algorithm:
`1 - adist_score / max_string_length`. Comparisons ignore case.
}
\examples{
source(system.file("extdata", "sample_flines.R", package = "nhdplusTools"))

hydro_location <- sf::st_sf(id = c(1, 2, 3),
                            geom = sf::st_sfc(list(sf::st_point(c(-76.86934, 39.49328)),
                                                   sf::st_point(c(-76.91711, 39.40884)),
                                                   sf::st_point(c(-76.88081, 39.36354))),
                                              crs = 4326),
                            totda = c(23.6, 7.3, 427.9),
                            nameid = c("Patapsco", "", "Falls Run River"))

flowpath <- dplyr::select(sample_flines,
                          comid = COMID,
                          totda = TotDASqKM,
                          nameid = GNIS_NAME,
                          REACHCODE,
                          ToMeas,
                          FromMeas)

indexes <- get_flowline_index(flowpath,
                              hydro_location,
                              search_radius = 0.2,
                              max_matches = 10)

disambiguate_flowline_indexes(indexes,
                              dplyr::select(flowpath, comid, totda),
                              dplyr::select(hydro_location, id, totda))

result <- disambiguate_flowline_indexes(indexes,
                                        dplyr::select(flowpath, comid, nameid),
                                        dplyr::select(hydro_location, id, nameid))

result[result$id == 1, ]

result[result$id == 2, ]

result[result$id == 3, ]

}
