% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoserver_tools.R
\name{query_usgs_geoserver}
\alias{query_usgs_geoserver}
\title{Query USGS Geoserver}
\usage{
query_usgs_geoserver(
  AOI = NULL,
  ids = NULL,
  type = NULL,
  filter = NULL,
  t_srs = NULL,
  buffer = 0.5
)
}
\arguments{
\item{AOI}{sf (MULTI)POINT or (MULTI)POLYGON. An 'area of interest' can
be provided as either a location (sf POINT) or area (sf POLYGON)
in any Spatial Reference System.}

\item{ids}{character or numeric. A set of identifier(s) from the data
type requested, for example if NHD, then a set of COMID(s).}

\item{type}{character. Type of feature to return
('huc08','huc12', 'nhd', 'catchment', 'waterbodies', 'gagesII').
If NULL (default) a data.frame of available resources is returned}

\item{filter}{character. An XML filter to pass to httr POST query}

\item{t_srs}{character (PROJ string or EPSG code) or numeric (EPSG code).
A user specified - target -Spatial Reference System (SRS/CRS) for returned objects.
Will default to the CRS of the input AOI if provided, and to 4326 for ID requests.}

\item{buffer}{numeric. The amount (in meters) to buffer a POINT AOI by for an
extended search. Default = 0.5}
}
\value{
a simple features (sf) object
}
\description{
Query the USGS  geoserver for spatial data by location,
area, or ID.
}
\details{
The returned object(s) will have the same
Spatial Reference System (SRS) as the input AOI. If a individual or set of
IDs are used to query, then the default geoserver CRS of EPSG:4326 is
preserved. In all cases, a user-defined SRS can be passed to \code{t_srs}
which will override all previous SRS (either input or default).
All buffer and distance operations are handled internally using in
EPSG:5070 Albers Equal Area projection
}
\keyword{internal}
