% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_utils.R
\name{util_map_player_ids}
\alias{util_map_player_ids}
\title{Retrieve a player ids from their names}
\usage{
util_map_player_ids(playerNames, map = getOption("nhlapi_player_map"))
}
\arguments{
\item{playerNames}{\code{character()}, vector of one or more player names.
Not case sensitive for convenience.}

\item{map}{\code{data.frame}, with 2 columns:
\itemize{
\item \code{nameMd5}: \code{character()} of hashed player names
\item \code{id}: \code{integer()} of player ids used by the NHL API
}}
}
\value{
\code{integer()}, named vector of player ids,
`NA_integer`` for those names where id was not
found.
}
\description{
Retrieve a player ids from their names
}
\examples{
  nhlapi:::util_map_player_ids(
    c("Joe SAKIC", "peter Forsberg", "test")
  )
}
