% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_checksum.R
\name{get_checksum}
\alias{get_checksum}
\title{Calculates NHS number checksums}
\usage{
get_checksum(nhs_number, full_output = FALSE)
}
\arguments{
\item{nhs_number}{A 9 digit NHS numbers to validate}

\item{full_output}{Boolean that controls display of warning messages}
}
\value{
Either the calculated checksum or the complete 10 digit NHS number including the checksum.
}
\description{
NHS numbers are 10 digit numbers where the 10th digit is a checksum.
This function takes the 9 core digits of the NHS number and calculates the checksums.
}
\details{
This function has been created using information from:
https://en.wikipedia.org/wiki/NHS_number
and various NHS sources
}
\examples{
get_checksum(123456788)
get_checksum(123456788, full_output = TRUE)
}
