% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_ml_rec.R
\name{bin_ml_rec}
\alias{bin_ml_rec}
\title{Maximum likelihood reconstruction of ancestral character states}
\usage{
bin_ml_rec(tree_data, ...)
}
\arguments{
\item{tree_data}{a list of two elements (phy and data) resulting from using the
function \code{\link[geiger]{treedata}}.}

\item{...}{other arguments from \code{\link[ape]{ace}}. Arguments \code{x},
\code{phy}, \code{type}, and \code{method} are fixed.}
}
\value{
A table with columns representing bins, rows representing first tip
states and then reconstructed nodes.
}
\description{
Maximum likelihood reconstruction of ancestral character states
}
\details{
Reconstructions are done using the function \code{\link[ape]{ace}} from the
\code{ape} package. The argument method is set as "ML" and the type
of variable is "discrete".
}
\examples{
# a simple tree
data("tree5", package = "nichevol")

# a matrix of niche charactes (1 = present, 0 = absent, ? = unknown)
dataTable <- cbind("241" = rep("1", length(tree5$tip.label)),
                   "242" = rep("1", length(tree5$tip.label)),
                   "243" = c("1", "1", "0", "0", "0"),
                   "244" = c("1", "1", "0", "0", "0"),
                   "245" = c("1", "?", "0", "0", "0"))
rownames(dataTable) <- tree5$tip.label

# list with two objects (tree and character table)
treeWdata <- geiger::treedata(tree5, dataTable)

# Maximum likelihood reconstruction
ml_rec <- bin_ml_rec(treeWdata)
}
