% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_polygons.R
\name{random_polygons}
\alias{random_polygons}
\title{Generation of random polygons in a given area}
\usage{
random_polygons(polygon, style = "TR", n_polygons = 100,
  n_vertices = 25, minimum_distance = 10, length_threshold = 5,
  buffer_distance = 0, save = FALSE, output_directory, overwrite = FALSE)
}
\arguments{
\item{polygon}{SpatialPolygonsDataFrame object. CRS WGS84 is required.}

\item{style}{(character) algorithm to be used when creating polygons. Options
are: "TR" for vertices randomly located across the entire area; and "BR" for
vertices placed randomly across the entire area and in nine blocks derived
from dividing the area in equal number of random points. Default = "TR".}

\item{n_polygons}{(numeric) number of polygons to be created; default = 100.}

\item{n_vertices}{(numeric) maximum number of vertices for polygons.}

\item{minimum_distance}{(numeric) approximate minimum distance in km for
separation among vertices. Default = 10.}

\item{length_threshold}{(numeric) approximate distance in km for producing
concavity in polygons. Default = 5.}

\item{buffer_distance}{(numeric) approximate distance in km to buffer
resulting polygons. Default = 0.}

\item{save}{(logical) whether or not to save the results in working directory.
Default = FALSE.}

\item{output_directory}{(character) name of the folder in which results will
be written.}

\item{overwrite}{(logical) whether or not to overwrite existing results in
\code{output_directory}. Default = FALSE.}
}
\value{
A list of all random polygons created names will be "r_polygon" plus numbers
from 1 to the number defined in \code{n_polygons}. A folder named as in
\code{output_directory} containing all resultant shapefiles of the polygons
will be created if \code{save} is set as TRUE.
}
\description{
random_polygons creates polygons of random size and complexity within
a given SpatialPolygonsDataFrame, trying to fill the area with the resultant polygons
in at least nine quadrants. This is designed to simulate virtual species' Ms (aka
"training" or "background" regions). Note that this function is experimental
but may be useful in generating accessible areas for virtual species to be
used in analysis and exploration.
}
\details{
Distances are approximate because 1 decimal degree is assumed to equal 111.32
km.

Style for random polygons "BR" may help to get smaller and more uniformly
distributed across the area.
}
\examples{
# crreating a simple polygon
rdata <- cbind(x = rnorm(100, -80, 12), y = rnorm(100, -3, 15))
WGS84 <- sp::CRS("+proj=longlat +datum=WGS84 +ellps=WGS84 +towgs84=0,0,0")
sp_data <- sp::SpatialPoints(rdata, proj4string = WGS84)
pol <- suppressWarnings(rgeos::gBuffer(sp_data, width = 10))
pol <- sp::SpatialPolygonsDataFrame(pol, data = data.frame(ID = 1),
                                    match.ID = FALSE)

# creating 5 random polygons in the whole area using the "BR" style
r_pols <- random_polygons(pol, style = "BR", n_polygons = 5)
}
