% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{score_tree}
\alias{score_tree}
\title{Helper function to assign bin scores to every tip in a given tree}
\usage{
score_tree(tree_data, include_unknown = FALSE)
}
\arguments{
\item{tree_data}{a list of two elements (phy and data) resulting from using
the function \code{\link[geiger]{treedata}}.}

\item{include_unknown}{(logical) whether or not there are unknown tips.}
}
\value{
a list of two elements (phy and data). Data is the median bin scored
as present or present + unknown.
}
\description{
Helper function to assign bin scores to every tip in a given tree
}
\examples{
# Simulate data table
dataTable <- cbind("241" = rep("1", 5),
                   "242" = rep("1", 5),
                   "243" = c("1", "1", "0", "0", "0"),
                   "244" = c("1", "1", "0", "0", "0"),
                   "245" = c("1", "?", "0", "0", "0"))
rownames(dataTable) <- c("GadusMorhua", "GadusMacrocephalus",
                         "GadusChalcogrammus", "ArctogadusGlacials",
                         "BoreogadusSaida")

# a simple tree
data("tree5", package = "nichevol")
tree5$tip.label <- c("GadusMorhua", "GadusMacrocephalus",
                     "GadusChalcogrammus", "ArctogadusGlacials",
                     "BoreogadusSaida")

# Unite data
treeWithData <- geiger::treedata(tree5, dataTable)

# Get a new tree with tips scored from median bin scores
score_tree(treeWithData, include_unknown = TRUE)
}
